// Spot welder
// More on: www.HomoFaciens.de

$fn = 100;

M3_hole = 3.5;
M3_nut_e = 6.3;
M4_hole = 4.5;
M5_hole = 5.5;
M6_hole = 6.5;
M5_nut_e = 8.79 + 0.3;
M6_nut_e = 11.05 + 0.3;
M8_nut_e = 14.38+1.5;
M12_nut_e = 21.3 + 1.0;
M12_hole = 12.5;

	pliers();
			

module pliers(){
	electrode_d = 6.5;
	p_l = 70;
	p_w = 4;
	p_h = 12;
	p_d = 15;
	pivot_h = 31;
	pivot_h2 = 21;
	pivot_w = 25;
	pivot_l = 10;
	pivot_X = 30;
	pivot_Z = 27;
	pivot_Z2 = 17;

	clamp_h = p_h;
	clamp_h2 = 40;
	clamp_w = 25;
	clamp_l = 10;
	clamp_X = -30;
	clamp_Z = p_h/2;
	
		
	difference(){
		union(){
			translate([0, 0, p_h/2])
			intersection(){
				rotate([0, 90, 0])
				cylinder(d=p_d, h=p_l, center=true);
				cubec([p_l, p_d, p_h]);
			}
			translate([pivot_X, 0, pivot_h/2])
			cubec([pivot_l, pivot_w, pivot_h]);

			translate([clamp_X, 0, clamp_h2/2])
			cubec([clamp_l, clamp_w, clamp_h2]);
		}
		translate([0, 0, p_h/2])
		rotate([0, 90, 0])
		cylinder(d=electrode_d, h=p_l+1, center=true);

		translate([pivot_X, 0, pivot_Z])
		rotate([90, 0, 0])
		cylinder(d=M3_hole, h=p_l+1, center=true);

		translate([pivot_X, 0, p_h/2])
		rotate([90, 0, 0]){
		  cylinder(d=M3_hole, h=p_l+1, center=true);
			cylinder(d=M3_nut_e, h=electrode_d+6, center=true, $fn=6);
		}

		translate([pivot_X, 0, p_h + 3])
		rotate([0, 90, 0]){
		  cylinder(d=M3_hole, h=p_l+1, center=true);
		}

		translate([pivot_X, 0, p_h+pivot_h/2+7])
		cubec([pivot_l+1, p_d, pivot_h]);

		translate([clamp_X, 0, p_h+pivot_h/2])
		cubec([pivot_l+1, p_d+1, pivot_h]);		
	}

  translate([0, 25, 0])
	difference(){
		union(){
			translate([0, 0, p_h/2])
			intersection(){
				rotate([0, 90, 0])
				cylinder(d=p_d, h=p_l, center=true);
				cubec([p_l, p_d, p_h]);
			}
			translate([pivot_X, 0, pivot_h2/2])
			cubec([pivot_l, p_d, pivot_h2]);

			translate([clamp_X, 0, p_h/2])
			cubec([pivot_l, p_d, p_h]);

		}
		translate([0, 0, p_h/2])
		rotate([0, 90, 0])
		cylinder(d=electrode_d, h=p_l+1, center=true);

		translate([pivot_X, 0, pivot_Z2])
		rotate([90, 0, 0])
		cylinder(d=M3_hole, h=p_l+1, center=true);		

		translate([pivot_X, 0, p_h/2])
		rotate([90, 0, 0]){
		  cylinder(d=M3_hole, h=p_l+1, center=true);
			cylinder(d=M3_nut_e, h=electrode_d+6, center=true, $fn=6);
		}
	}

}


module cubec(size=[1,1,1]){
  cube(size, center=true);
}


