// Direct granules extruder Project V6.2
// More on: www.HomoFaciens.de

include <Gears/Gears.scad>

$fn = 100;

M3_hole = 3.5;
M3_nut_e = 6.3;
M4_hole = 4.5;
M5_hole = 5.5;
M6_hole = 6.5;
M5_nut_e = 8.79 + 0.3;
M6_nut_e = 11.05 + 0.3;
M8_nut_e = 14.38+1.5;
M12_nut_e = 21.3 + 1.0;
M12_hole = 12.5;

// Ball bearings
bb8_do = 22 + 0.5;
bb8_h = 7;

bb10_do = 30 + 0.5;
bb10_h = 9;
bb12_di = 12;
bb12_do = 28.1;
bb12_h = 8;

//linear bearings
lm8uu_do = 15;
lm8uu_l = 24;

lm10luu_do = 19 + 0.5;
lm10luu_l = 55;

// Stepper motor
motor_e = 42;
motor_l = 40;
motor_m = 31;
motor_m_r = sqrt(2*motor_m/2*motor_m/2);
motor_shaft = 5.5;
motor_shaft_shift = 4.9;

// Commercial gearbox mounts
gear_mnt_X = sqrt(35*35/2);
gear_mnt_Y = sqrt(35*35/2);
motor_mnt_X = 25; 
motor_mnt_Y = 12.5*0;

// 3D printed gearbox mount
print_gear_mnt_X = 20;
print_gear_mnt_Y = 17;


// Mount grid
mg_dis = 15;
mg_d = 5.2;

// hotend mount holes
hot_m_d = 3;
hot_m_dis = 28;

// Copper pipe dimensions
cp_d = 15;

// Heater cartridge dimensions
heater_d = 6;
heater_dis = 15;
heater_z_shift = -4;

// Temperature sensor dimensions
temperature_z_shift = 3;
temperature_x_shift = 8;
temperature_d = 2;  

// Cold end fan
fan_m_dis = 55;

// Part cooling fan 
fm_screw_dis = 44;


// X rails dimensions
xa_bar_d = 8.2;
xa_bar_dis = 80;


// Force sensor dimensions
//fs_screw_dis1 = 15;
//fs_screw_dis2 = 40;
//fs_l = 80;
//fs_e = 13.5;

// Force sensor Nextruder mount screws
fs_screw_dis_h = 31;
fs_screw_dis_m = 32.5; //Stimmt's ?
fs_shift = 22;

// Feeder tube
ft_do=16.5;


// Hopper dimensions
h_h = 33;
h_h2 = 45;
h_wall = 2;
h_wall_b = 1;
h_wb = 60;
//h_l = 80;
h_lb = 34.5; // 44
h_inner_cyl = 40;
// Hopper top mount screw distance
mnt_top_X = 40;
mnt_top_Y = 5;

// Hopper bottom mount screws
hbm_Y1 = 65;
hbm_Y2 = 75;
hbm_dis = hbm_Y2 - hbm_Y1;

// Hopper front door
hfd_screw_dis = h_wb + 10;
// Front feeding cone mount point
ffc_Y = 10;
  
// Feeding hole position
fhp_Z = 13;
fhp_angle = 70;
fhp_d1 = 19;
fhp_d2 = 25.5;

// Top cone screws
tc_screw_dis = 40;

// Magnet dimensions
mag_d = 6.5; // with 0.5mm tolerance
mag_h = 5;
mag_X1 = (h_inner_cyl + mag_d)/2 + 1;
mag_Y1 = 0;
mag_X2 = mag_X1;
mag_Y2 = 10;
mag_X3 = mag_X1;
mag_Y3 = -10;

// gearbox parameters
mm_per_tooth = 3;
pinion_teeth = 11; // Must be an integer of planet_no
pinion_shift = -9.8;
guide_teeth = 13;
ring_teeth = 32;
gear_w = 15;
gr_do = 38;
gearbox_do = 43;


cut = 0;
assembled = 0;

if (assembled == 1){
  difference(){
    union(){
      hopper();

//      if(0)
      translate([0, -22, 24.0])
      rotate([90, 0, 0])
      hopper_front_door();

      if(0)
      translate([0, -24+5.9, 16.5])
      rotate([90, 0, 0])
      hopper_front_door_cone();
      
      translate([0, 76, -24.0])
      rotate([0, 0, 90])
      hopper_rear_mount();

      
      translate([0, -5, h_h+5*0])
      rotate([0, 0, 180])
      motor_plate();
      
//      if(0)
      translate([0, 0, -1])
      rotate([0, 0, -90])
      water_cooling(); // cooling
      
      translate([0, 50, 30])
      rotate([90, 0, 0])
      extruder_mount(0);
      
      if(0)
      translate([0, 30, 30])
      rotate([90, 0, 180])
      extruder_mount(1);
      
      if(0)
      translate([0, 7.5, 92])
      rotate([0, 0, 180])
      stepper_clamp();
      
      if(0)
      translate([59, 6.5, 46])
      rotate([180, 0, -90])
      fan_mount();
      
//      translate([-7, 50, 110])
//      rotate([-90, 0, 180])
//      cable_mount();
      
      
    }
    if(cut == 1){
      translate([0,25,0]){
        cube(size=[100,50,200], center=true);
      }
    }
  }
}
else if (assembled == 2){

      storage_mount();
	
	    translate([0, 0, 55])
	    gimbal();
	
	    translate([0, 0, -2])
	    rotate([180, 0, 22])
	    top_cone(1); // Cone

}
else if (assembled == 3){
  difference(){
		union(){
			motor_plate_printed_gearbox();
	    translate([0, 0, 12]){
			  gear_ring();
				translate([0, pinion_shift, 12])
				rotate([0, 0, 16])
				pinion();
				
				translate([0, 0, -4.2])
				spacer(20,12,3,1);
			}
//	    translate([0, 0, 45])gearbox_lid();
		}
    if(cut == 1){
      translate([0,25,0]){
        cube(size=[100,50,200], center=true);
      }
    }
	}
}
else{
  difference(){
    union(){
//      extruder_mount(0);  // Rear part
//      extruder_mount(1);  // Front part
//      hopper(1); // Hopper
//			hopper_spacer(spacer_h = 4);
//      hopper_spacer_bottom();
//      hopper_front_door();
//      hopper_rear_mount();
//      stepper_clamp();
//      arduino_mount();
//			water_cooling_drill_template(); // cooling
//			heating_block_drill_template();
			
//			flex_tube();
//			brush();

//      storage_mount();
//			cable_clamp_round();
//			cable_clamp_square();
			
//      feeder_tube_guides();
//      cable_mount();
//      fan_mount();
//      mirror([0,1,0])fan_mount();
//      fan_nozzle();
//      fan_nozzle_prusa();
//      motor_plate_NEMA17();
//			motor_plate_commercial_gearbox();
//			motor_plate_printed_gearbox();
//			gearbox_lid();
			gear_ring();
//			nut_reduction();
//      stepper_spacer();
//			translate([0, pinion_shift, 0])pinion();
//			gimbal(26.5-10, 1);
//			gimbal();
//			water_container();
//			pump_controller_mount();
//      printer_mount();
//      handle();

//      mirror([0,1,0])X_Axis(0);
//      X_Axis(1);
//      Z_bar_mount();
//      mirror([1,0,0])Z_bar_mount();
//      top_cone(1); // Cone
//      top_cone(2); // Lid
//      top_cone(3); // Infill cone


      
    }
    if(cut == 1){
      translate([0,25,0]){
        cube(size=[100,50,200], center=true);
      }
    }
  }
}

module heating_block_drill_template(){
	hb_l = 20.5;
	hb_w = 20.5;
	hb_h = 17;
	
	hbdt_l = hb_l + 10;
	hbdt_w = hb_w + 10;
	hbdt_h = hb_h + 5;
	
	threat_d = 3;
	
	extruder_d = 10*0+3;
	extruder_X = 3;

	extruder_screw_d = threat_d;
	extruder_screw_X = extruder_X;
	extruder_screw_Y = hbdt_w/2;
	extruder_screw_Z =hb_h/2+5;
	
	heater_d = 6*0+3;
	heater_X = -6;
	heater_Z = hbdt_h-hb_h/2+2;

	heater_screw_d = threat_d;
	heater_screw_X = heater_X;
	heater_screw_Z = heater_Z/2;
	
	sensor_d = 3;
	sensor_X = -2;
	sensor_Y = hb_w/2-3;
	sensor_Z = 10;
	sensor_l = 20;
	
	
	difference(){
		translate([0, 0, hbdt_h/2])
		cubec([hbdt_l, hbdt_w, hbdt_h]);
		
		// Heating block
		translate([0, 0, hb_h/2+5.1])
		cubec([hb_l, hb_w, hb_h]);
		
		// Extruder hole
		translate([extruder_X, 0, hbdt_h/2])
		cylinder(d=extruder_d, h=hbdt_h+1, center=true);

		// Extruder screw hole
		translate([extruder_screw_X, extruder_screw_Y, extruder_screw_Z])
		rotate([90, 0, 0])
		cylinder(d=extruder_screw_d, h=hbdt_w+1, center=true);

		// Heater cartridge hole
		translate([heater_X, 0, heater_Z])
		rotate([90, 0, 0])
		cylinder(d=heater_d, h=hbdt_w+1, center=true);

		// Heater cartridge screw hole
		translate([heater_screw_X, 0, heater_screw_Z])
		cylinder(d=heater_screw_d, h=heater_Z+1, center=true);

		// Sensor hole
		translate([sensor_X, sensor_Y, sensor_Z])
		rotate([90, 0, 0])
		cylinder(d=sensor_d, h=sensor_l+1, center=true);

		// Sensor screw hole
		translate([sensor_X, sensor_Y, 0])
		cylinder(d=threat_d, h=hbdt_h*2.1, center=true);
	}
}


module stepper_spacer(){
	ss_l = 30;ss_w = 14;
	ss_h = 6;
	
	roundedRect([ss_l, ss_w, ss_h], 2);
}

module nut_reduction(){
	nr_h = 8;
	translate([0, 0, nr_h/2])
	difference(){
		cylinder(d=M8_nut_e-0.5, h=nr_h, center=true, $fn=6);
//		translate([0, 0, 3.5])  // M6
		translate([0, 0, 5])    // M5
		cylinder(d=M5_nut_e+0.9, h=nr_h, center=true, $fn=6);
	}
}


module gearbox_lid(){
	gbl_shift_Y = 10;
	gbl_wall = 5;
	gbl_l = 2 * print_gear_mnt_X + 10;
  gbl_w = gearbox_do+gbl_shift_Y;

	
	difference(){
		translate([0, -gbl_shift_Y/2, 0])
	  roundedRect([gbl_l, gbl_w, gbl_wall], 5);

    // Stepper motor cuts
    translate([0, pinion_shift, gbl_wall/2]){
		  cylinder(d=23, h=gbl_wall+1, center=true);
			for(i=[0:1:1])mirror([i,0,0])
			for(j=[0:1:1])mirror([0,j,0])
				translate([motor_m/2, motor_m/2, 0]){
				cylinder(d=M3_hole, h=gbl_wall+0.1, center=true);
				translate([0, 0, -2])
				hull(){
				  cylinder(d=M3_hole, h=gbl_wall, center=true);
					translate([0, 0, -2])
					cylinder(d=7, h=gbl_wall, center=true);
				}
			}
			
		}

    // Mount holes gearbox
    for(i=[0:1:1])mirror([i,0,0])
		for(j=[0:1:1])mirror([0,j,0])
      translate([print_gear_mnt_X, print_gear_mnt_Y, gbl_wall/2]){
			cylinder(d=M3_hole, h=gbl_wall+0.1, center=true);
			translate([0, 0, 1])
			cylinder(d=M3_nut_e, h=gbl_wall, center=true, $fn=6);
		}
	}
}

module pinion(){
	
	brim_h = 1;
	brim_d = 20;
	
	shaft_di=5.2;
	pinion_h = gear_w+5;
	
	difference(){
		union(){
			// Bottom gear
			translate([0, 0, pinion_h/2])
			gear(mm_per_tooth,pinion_teeth,pinion_h,0,0);	
			
			// Brim
			translate([0, 0, brim_h/2])
			cylinder(d=brim_d, h=brim_h, center=true);
		}

		// Motor shaft cut
    cylinder(d=shaft_di, h=12, center=true);
		translate([0, 0, pinion_h/2])
		intersection(){
		  cylinder(d=shaft_di, h=pinion_h+1, center=true);
			translate([0, -0.5, 0])
			cubec([shaft_di*2,shaft_di,pinion_h+1]);
		}
		
	}
}

module gear_ring(draft=false){
  
	gr_wall = 7.5;
  gr_h = gear_w + gr_wall+4.5;
	clearance = -0.0;
	
	// Stepper mount
	sm_r = gr_do/2+5;
	sm_w = 12;
	sm_h = 5;
	
	// Case mount
	cm_w = 50;
	cm_h = 5;
	cm_l =  gr_do/2 + 20;
	
//	screw_r = gr_do/2 - 4;
  
	// Bolt dimensions
	b_do = 12;
	b_h1 = 5;
	b_h2 = 17;
	
	// Screw coupling dimensions
	sc_do = 35;
	sc_di = 20;
	sc_h = 12;
	sc_nut_h = 8;
	sc_h2 = 2;
	
	// Stirrer on lid dimensions
//	s_h1 = 21;
	s_h1 = 21-5*0;
	s_l1 = 8;
	s_shift_X = 6.5;
	s_wall = 3;
	
//	translate([60, -30, 11])
//	cylinder(d=1, h=22, center=true);
	
	// Spacers
//	if(0)
	{
		translate([35, 12, 0])
		spacer(20,12,4,1);

		translate([35, -12, 0])
		spacer(20,12,3,1);
	}
	
	// Screw coupling
//	if(0)
	translate([60, 30, 0])
	difference(){
		union(){
			translate([0, 0, sc_h/2])
			cylinder(d=sc_di, h=sc_h, center=true);

			for(i=[0:1:2])rotate([0, 0, i*120])
			translate([sc_do/2-4, 0, 0]){
				translate([0, 0, sc_h/2])
				hull(){
				  cylinder(d=8, h=sc_h, center=true);
					translate([-10, 0, 0])
					cylinder(d=8, h=sc_h, center=true);
				}
			}
		}

    // Screw head
		translate([0, 0, sc_h-sc_nut_h/2])
		cylinder(d=M8_nut_e, h=sc_nut_h+0.1, center=true, $fn=6);

    // Connection screw holes
		for(i=[0:1:2])rotate([0, 0, i*120])
		translate([(b_do-M3_hole)/2, 0, 0]){
			translate([0, 0, sc_h/2])
		  cylinder(d=M3_hole, h=sc_h+1, center=true);
			translate([0, 0, sc_h-sc_nut_h])
		  cylinder(d=6, h=6, center=true);
			
		}

		for(i=[0:1:2])rotate([0, 0, i*120])
		translate([sc_do/2-4, 0, 0]){
			translate([0, 0, sc_h/2])
		  cylinder(d=M3_hole, h=sc_h+1, center=true);
			hull(){
		    cylinder(d=M3_hole, h=8, center=true);
				rotate([0, 0, 30])
				cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
			}
		}

	}
	
	// Screw coupling lid (stirrer)
//	if(0)
	translate([60, -30, 0])
	difference(){
		union(){
			// Lid
			translate([0, 0, s_wall/2])
			cylinder(d=sc_di, h=s_wall, center=true);

      // Stirrer base plate
			for(i=[0:1:2])rotate([0, 0, i*120])
			translate([sc_do/2-4, 0, 0]){
				translate([0, 0, s_wall/2])
				hull(){
					cylinder(d=8, h=s_wall, center=true);
					translate([-10, 0, 0])
					cylinder(d=8, h=s_wall, center=true);
				}
			}

			// Stirrer
//			if(0)
			for(i=[0:1:2])rotate([0, 0, i*120+0])
			hull(){
			  translate([(sc_do-s_l1)/2-0.0, 0, 0])
				roundedRect([s_l1, 8, s_h1], 4);
			  translate([7.0, 0, s_h1])
				cubec([s_wall, s_wall, sc_h2]);
			}
		}

    // center hole
		translate([0, 0, s_wall/2])
		cylinder(d=8, h=s_wall+0.1, center=true);

    // Lid mount holes
		for(i=[0:1:2])rotate([0, 0, i*120])
		translate([sc_do/2-4, 0, 0]){
			translate([0, 0, s_wall/2])
		  cylinder(d=M3_hole, h=s_wall+1, center=true);
			translate([0, 0, s_h1/2+4])
		  cylinder(d=6, h=s_h1+2, center=true);
			if(0)
			hull(){
				translate([11, 0, (s_h1-7)/2+3.5])
				cubec([20, 20, s_h1-7]);
				translate([15, 0, s_h1-1])
				cubec([20, 20, 1]);
			}
		}

	}
	
	
	// Bolt
//	if(0)
	translate([60, 0, 0])
	difference(){
		union(){
			translate([0, 0, b_h1/2])
			cylinder(d=M12_nut_e-1, h=b_h1, center=true, $fn=6);

			translate([0, 0, b_h2/2])
			cylinder(d=b_do, h=b_h2, center=true);
		}
		
		for(i=[0:1:2])rotate([0, 0, i*120])
		translate([(b_do-M3_hole)/2, 0, 0]){
			translate([0, 0, b_h2/2])
		  cylinder(d=M3_hole, h=b_h2+1, center=true);
			hull(){
		    cylinder(d=M3_hole, h=8, center=true);
				rotate([0, 0, 30])
				cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
			}
		}
	}
	
	// Gear ring
//	if(0)
  difference(){
    union(){
      // Main cylinder
      translate([0, 0, gr_h/2])
      cylinder(d=gr_do, h=gr_h, center=true, $fn=100);			
    }

    // Gear teeth
		if(!draft)
    translate([0, 0, gr_h/2+gr_wall])
    gear(mm_per_tooth-clearance, ring_teeth, gr_h, 0, 0);			

		translate([0, 0, gr_wall/2+2])
		cylinder(d=M12_nut_e, h=gr_wall, center=true, $fn=6);
		translate([0, 0, gr_wall/2])
		cylinder(d=M12_hole, h=gr_wall+1, center=true);
  }
	  
}


module spacer(do=10, di=M3_hole, h=20, no=4){
	
	for(i=[0:1:no-1])
	translate([i*(do+1), 0, h/2])
	difference(){
	  cylinder(d=do, h=h, center=true);
		cylinder(d=di, h=h+1, center=true);
	}
	
}

module brush(){
	b_wall = 0.4;
	b_wall_2 = 1;
	b_l = 35;
	b_ls = 7;
	b_w = 1.4*10;
	b_flap = 1;
	b_gap = 0.4;
	flap_no = b_w / (b_flap + b_gap) - 1;
	
	for(b=[0:1:2])
	translate([b*(b_w+1), 0, b_wall/2]){
		difference(){
			union(){
				translate([0, 0, (b_wall_2-b_wall)/2])
				cubec([b_w, b_ls, b_wall_2]);
				for(i=[0:1:flap_no])
				translate([i*(b_flap+b_gap)-b_w/2+b_flap/2, b_l/2, 0])
				cubec([b_flap, b_l, b_wall]);
			}
			cylinder(d=M3_hole, h=b_wall_2*2.1, center=true);
		}
	}
}

module flex_tube(){
	ft_wall = 0.6;
	ft_l = 25;
	ft_ls = 5;
	ft_w = 20.0 * 3.14;
	ft_flap = 2;
	ft_gap = 0.4;
	flap_no = ft_w / (ft_flap + ft_gap) - 1;
	
	translate([0, 0, ft_wall/2]){
		cubec([ft_w, ft_ls, ft_wall]);
		for(i=[0:1:flap_no])
		translate([i*(ft_flap+ft_gap)-ft_w/2+ft_flap/2, ft_l/2, 0])
		cubec([ft_flap, ft_l, ft_wall]);
	}
}

module cable_clamp_round(){
  cc_di = 20.5;
  cc_wall = 2;
	cc_do = cc_di + 2 * cc_wall;
	cc_h = 5;
	cc_gap = cc_di-5;
	wire_do = 7;
	wire_di = 3;
	knob_X = 8;
	knob_Y = cc_gap/2;
	
	translate([0, 0, cc_h/2]){
		difference(){
			union(){
				cylinder(d=cc_do, h=cc_h, center=true);
				translate([-cc_do/2, 0, 0])
				cylinder(d=wire_do, h=cc_h, center=true);
			}
			cylinder(d=cc_di, h=cc_h+1, center=true);
			translate([cc_do/2, 0, 0])
			cubec([cc_do, cc_gap, cc_h+1]);
			
			translate([-cc_do/2, 0, 0])
			cylinder(d=wire_di, h=cc_h+1, center=true);
			cubec([cc_do, wire_di, cc_h+1]);
		}
		for(i=[0:1:1])mirror([0,i,0])
		translate([knob_X, knob_Y, 0])
		cylinder(d=3, h=cc_h, center=true);
	}
	
}

module cable_clamp_square(){
  cc_e_i = 15.5;
  cc_wall = 2;
	cc_e_o = cc_e_i + 2 * cc_wall;
	cc_h = 5;
	cc_gap = cc_e_i-3;
	wire_do = 7;
	wire_di = 3;

	knob_X = cc_e_i/2+1;
	knob_Y = cc_gap/2;
	
	translate([0, 0, cc_h/2]){
		difference(){
			union(){
				cubec([cc_e_o, cc_e_o, cc_h]);
				translate([-cc_e_o/2, 0, 0])
				cylinder(d=wire_do, h=cc_h, center=true);
			}
			cubec([cc_e_i, cc_e_i, cc_h+1]);
			translate([cc_e_o/2, 0, 0])
			cubec([cc_e_o, cc_gap, cc_h+1]);
			
			translate([-cc_e_o/2, 0, 0])
			cylinder(d=wire_di, h=cc_h+1, center=true);
			cubec([cc_e_o, wire_di, cc_h+1]);
		}
		for(i=[0:1:1])mirror([0,i,0])
		translate([knob_X, knob_Y, 0])
		cylinder(d=3, h=cc_h, center=true);
	}
	
}


module feeder_tube_guides(){
	tube1_d = 20.5;
	tube2_d =  15.7;
	ftg_do_1 = 26.5 + 4;
	ftg_h_1 = 15;
	
	ftg_do_2 = 17.5;
	ftg_di_2 = 14.5;
	ftg_h_2 = 3;
	
  translate([0, 0, ftg_h_1/2])
	difference(){
		cylinder(d=ftg_do_1, h=ftg_h_1, center=true);
		cylinder(d=tube2_d, h=ftg_h_1+1, center=true);
		translate([0, 0, 2])
		cylinder(d=tube1_d, h=ftg_h_1, center=true);
		rotate([90, 0, 0]){
			cylinder(d=M3_hole, h=ftg_do_1, center=true);
			cylinder(d=M3_nut_e, h=ftg_do_1-4, center=true, $fn=6);
		}
	}
	
//	if(0)
  translate([25, 0, ftg_h_2/2])
	difference(){
		cylinder(d=ftg_do_2, h=ftg_h_2, center=true);
		cylinder(d=ftg_di_2, h=ftg_h_2+1, center=true);
		translate([0, 0, ftg_h_2-1])
		cylinder(d=tube2_d, h=ftg_h_2+1, center=true);
	}
	
}

module handle(){
	hd_l1 = 120;
	hd_l2 = 170;
	hd_h = 60;
	hd_d = 20;
	hd_wall = 2;
	plate = 15;
	
	a = hd_l1/2+(hd_l2-hd_l1)/4;
	b = (hd_l2-hd_l1)/2;
	
	
	intersection(){
  	cubec([hd_l2*2.5, hd_h*2.5, hd_d]);
  	difference(){
			union(){
				rotate([0, 90, 0])
				cylinder(d=25, h=hd_l1, center=true);
				for(i=[0:1:1])mirror([i,0,0]){
					hull(){
						translate([hd_l1/2, 0, 0])
						rotate([0, 90, 0])
						cylinder(d=25, h=5, center=true);
						translate([a, hd_h, 0])
						cubec([b, 2, hd_h]);
					}
					translate([a, hd_h+plate/2-5, -hd_d/2])
					roundedRect([b+15, plate+5, hd_wall], 2);
				}
			}
			for(i=[0:1:1])mirror([i,0,0])
			translate([hd_l2/2-10, hd_h/2, 0])
			rotate([90, 0, 0]){
			  cylinder(d=M3_hole, h=hd_h+10, center=true);
				rotate([0, 0, 30])
				cylinder(d=8, h=hd_h-5, center=true);
			}

			for(i=[0:1:1])mirror([i,0,0]){
				translate([a+10, hd_h+plate/2, -hd_d/2])
				cylinder(d=M3_hole, h=hd_wall+10, center=true);
				translate([a-10, hd_h+plate/2, -hd_d/2])
				cylinder(d=M3_hole, h=hd_wall+10, center=true);
			}
	  }
	}
}

module printer_mount(){
	pm_w = 10;
	pm_ws = 30;
	pm_l = 60;
	pm_h = 40;
	pm_nut_Z = 25;
	pm_wall = 2;
	
	difference(){
		union(){
			roundedRect([pm_l, pm_ws, pm_wall], 5);
			hull(){
				roundedRect([pm_l, pm_w, pm_wall], 5, [1,0,1,0]);
				translate([pm_l/2, 0, pm_h/2])
				rotate([0, 90, 180])
				roundedRect([pm_h, pm_w, pm_wall], 5, [1,0,1,0]);
			}
			translate([pm_l/2, 0, pm_nut_Z])
			rotate([90, 0, 0])
			cylinder(d=5, h=pm_w, center=true);
		}
		
		for(i=[0:1:1])mirror([0,i,0])
		translate([0, 11, pm_wall/2])
		cylinder(d=M3_hole, h=pm_wall+1, center=true);
	}
	
}


module pump_controller_mount(){
	pcm_wall = 2;
	pcm_w = 50;
	pcm_l = 30;
	pcm_screw_dis = 25;
	pcm_h = 5;
	
	mount_X = pcm_l/2-5;
	mount_Y = pcm_screw_dis/2;
	
	difference(){
		union(){
		  roundedRect([pcm_l, pcm_w, pcm_wall], 1);
			
			for(i=[0:1:1])mirror([0,i,0])
			for(j=[0:1:1])mirror([j,0,0])
			translate([mount_X, mount_Y, pcm_h/2])
  		cylinder(d1=8, d2=4-j*2, h=pcm_h, center=true);

		}
		
		for(i=[0:1:1])mirror([0,i,0])
		translate([mount_X, mount_Y, pcm_h/2])
		cylinder(d=1.5, h=pcm_h+1, center=true);
		
		for(i=[0:1:1])mirror([0,i,0])
		translate([0, pcm_w/2-5, pcm_wall/2])
		cylinder(d=M3_hole, h=pcm_wall+1, center=true);
	}
}

module water_container(){

  // Glass holder	
	gh_di = 960;
	gh_h = 70;
	gh_w = 15;
	gh_ws = 30;
	gh_l = 30;
	gh_wall = 2;

  for(p=[0:1:2])rotate([0, 0, p*120])
  translate([42, 0, 0]){
		difference(){
			union(){
				translate([(gh_l-gh_w)/2, 0, 0])
				roundedRect([gh_l, gh_ws, gh_wall], 5);
				hull(){
					translate([0, 0, gh_h/2])
					cylinder(d=gh_w, h=gh_h, center=true);
					translate([gh_l-gh_w/2, 0, gh_wall/2])
					cylinder(d=2, h=gh_wall, center=true);
				}
			}
			for(i=[0:1:1])mirror([0,i,0])
			translate([10, 10, gh_wall/2])
			cylinder(d=M3_hole, h=gh_wall+1, center=true);
		}
	}
	
	// pump holder
	ph_di = 37;
	ph_h = 80;
	ph_hs = 4;
	ph_wall = 2;
	ph_do = ph_di + 2 * ph_wall;
	ph_ds = 65;
	
//	if(0)
	difference(){
		union(){
			translate([0, 0, ph_hs/2])
			cylinder(d=ph_ds, h=ph_hs, center=true);
			translate([0, 0, ph_h/2])
			cylinder(d=ph_do, h=ph_h, center=true);
		}

    // Mount screws
		for(i=[0:1:2])rotate([0, 0, i*120])
		translate([25, 0, ph_hs/2]){
      cylinder(d=M3_hole, h=ph_hs+1, center=true);
			translate([0, 0, 1.6])
			cylinder(d=M3_nut_e, h=ph_hs+1, center=true, $fn=6);
		}
		
    // Center cut
		translate([0, 0, ph_h/2])
		cylinder(d=ph_di, h=ph_h+1, center=true);

	}
	
}

module gimbal(hole = ft_do, type = 0){
	g_tol = 6;
	g_d1 = hole + 10;
	g_d2 = g_d1 + g_tol + 15;
	g_h = 10;
	
	echo(g_d2);
	
	// Inner ring
	if(type == 0)
	translate([0, 0, g_h/2])
//	rotate([0, 20, 0])
	difference(){
		cylinder(d=g_d1, h=g_h, center=true);
		cylinder(d=hole, h=g_h+1, center=true);
		if(type == 0)
		translate([0, 0, g_h/4])
		cylinder(d1=hole, d2=hole+4, h=g_h/2+.1, center=true);
		rotate([90, 0, 0])
		cylinder(d=M3_hole, h=g_d1, center=true);
	}

  // Outer ring
	translate([0, 0, g_h/2])
	difference(){
		cylinder(d=g_d2, h=g_h, center=true);
		intersection(){
		  cylinder(d=g_d1+g_tol, h=g_h+1, center=true);
			if(type == 1)
			cubec([g_d1+g_tol, g_d1+g_tol-3, g_h+1]);
	  }
		rotate([90, 0, 0]){
		  cylinder(d=M3_hole, h=g_d2, center=true);
//			if(type == 0)
			cylinder(d=M3_nut_e, h=g_d1+g_tol+5-type*5, center=true, $fn=6);
//			translate([0, 0, g_d2/2-1.5])
//			cylinder(d=M3_nut_e, h=3, center=true, $fn=6);
		}

		rotate([0, 90, 0])
    cylinder(d=M3_hole, h=g_d2, center=true);
		
		if(type == 1) // Cut half
		difference(){
			translate([0, g_d2/2, 0])
			cubec([g_d2, g_d2, g_h+1]);
			rotate([0, 90, 0])
			cylinder(d=g_h, h=g_d2, center=true);
		}
	}
	
	
}

module storage_mount(showBody = true){
	tube_d = 20.5;
	tube_e = 15.99;
	sm_base_bot_X = 400;
	sm_base_top_X = 60;
	sm_base_bot_Y = 150;
	sm_base_top_Y = 60;
	sm_tube_l = 900;
	sm_h = 30;
	sm_d = 32;
	sm_wall = 2;
	sm_wall2 = 1.5;
	sm_cut_d1 = 40;
	sm_cut_d2 = 80;
	sm_cut_d3 = 40;
	
	e = sm_base_top_X + sm_d;
	a=(sm_base_bot_X-sm_base_top_X)/2;
	b=(sm_base_bot_Y-sm_base_top_Y)/2;
	alpha = asin(a/sm_tube_l);
	beta = asin(b/sm_tube_l) * 2;
	echo(a, alpha);

  tc_d_out2 = 28;
  tc_d_out3 = 6;
  tc_do_1 = tc_d_out3 + 2*sm_wall2;
  tc_do_2 = tc_d_out2 + 2*sm_wall2;

  tc_h2 = 55;
	tc_socket_d = tc_screw_dis*sqrt(2)+15;

  // Pivot point tower
  pt_h = tc_h2 + 10;
	pt_h2 = 50;
	pt_X = 30;
	pt_z = tc_h2 + 5;
	pt_l = 15;
	pt_w = 10;

  // Bar feet dimensions
	bf_ds = 60;
	bf_d = 32;
	bf_h = 40;
	bf_screw_r = 25;

  // Aluminium bar feet
  translate([110, 0, 0])
	for(i=[0:1:1])mirror([i,0,0])
	for(j=[0:1:1])mirror([0,j,0])
	translate([bf_ds/2+1, bf_ds/2+1, 0])
  difference(){
		union(){
			translate([0, 0, sm_wall/2])
			cylinder(d=bf_ds, h=sm_wall, center=true);

      rotate([alpha, beta*i, 0])
			translate([0, 0, bf_h/2-3])
			cylinder(d=bf_d, h=bf_h, center=true);
			
		}
		
		// Bar cut
		rotate([alpha, beta*i, 0])
		translate([0, 0, bf_h/2-3]){
			if(0){
    	  cylinder(d=tube_d, h=bf_h+1, center=true);
			}
			else{
				cubec([tube_e, tube_e, bf_h+1]);
			}
			rotate([90, 0, 0]){
  	    cylinder(d=M3_hole, h=bf_d+1, center=true);
				rotate([0, 0, 30])
				cylinder(d=M3_nut_e, h=tube_d+8, center=true, $fn=6);
			}
		}
		
		// Mount screws bottom
		for(r=[0:1:2])rotate([0, 0, r*120])
		translate([bf_screw_r, 0, sm_wall/2])
		cylinder(d=M3_hole, h=sm_wall+1, center=true);
		
		// bottom cut
		translate([0, 0, -10])
		cylinder(d=bf_ds*2, h=20, center=true);
	}


  // Pivot point feed tube
	if(showBody)
  difference(){
		union(){
			for(i=[0:1:1])mirror([i,0,0])
			translate([pt_X,0, 0])
			roundedRect([pt_w, pt_l, pt_h], 2);
			
			for(i=[0:1:1])mirror([0,i,0])
			translate([0, (pt_l-sm_wall)/2, pt_h2/2])
			cubec([pt_X*2, sm_wall, pt_h2]);
		}
		translate([0, 0, pt_z])
		rotate([0, 90, 0]){
		  cylinder(d=M3_hole, h=e+1, center=true);
			cylinder(d=M3_nut_e, h=pt_X*2, center=true, $fn=6);
		}

    translate([0, 0, tc_h2/2])
    cylinder(d1=tc_d_out2, d2=tc_d_out3, h=tc_h2+0.1, center=true);
	}
	
	if(showBody)
	difference(){
		union(){
		  roundedRect([e, e, sm_h], 5);

      // Outlet cone
      translate([0, 0, tc_h2/2])
      cylinder(d1=tc_do_2, d2=tc_do_1, h=tc_h2, center=true);
			
			// Tube mounts
			for(i=[0:1:1])mirror([i,0,0])
		  for(j=[0:1:1])mirror([0,j,0])
			translate([sm_base_top_X/2, sm_base_top_Y/2, 0])
			rotate([-alpha, beta*i, 0])
			translate([0, 0, sm_h/2])
 	    cylinder(d=sm_d, h=sm_h+10, center=true);
		}

    // Center cut outlet cone
    translate([0, 0, tc_h2/2])
    cylinder(d1=tc_d_out2, d2=tc_d_out3, h=tc_h2+0.1, center=true);

    // Tube mount cuts
		for(i=[0:1:1])mirror([i,0,0])
		for(j=[0:1:1])mirror([0,j,0])
    translate([sm_base_top_X/2, sm_base_top_Y/2, 0])
		rotate([-alpha, beta*i, 0])
		translate([0, 0, sm_h/2+14]){
			if(0){
    	  cylinder(d=tube_d, h=sm_h+1, center=true);
			}
			else{
				cubec([tube_e, tube_e, sm_h+1]);
			}
			rotate([90, 0, 0]){
  	    cylinder(d=M3_hole, h=sm_d+1, center=true);
				rotate([0, 0, 30])
				cylinder(d=M3_nut_e, h=tube_d+8, center=true, $fn=6);
			}
		}
		
		translate([0, 0, sm_wall])
		difference(){
		  roundedRect([e-2*sm_wall, e-2*sm_wall, sm_h], 5);


      // Leave outlet cone
      translate([0, 0, tc_h2/2-sm_wall])
      cylinder(d1=tc_do_2, d2=tc_do_1, h=tc_h2, center=true);
			
			// Center hole
//			translate([0, 0, (sm_h-sm_wall)/2])
//			cylinder(d1=sm_cut_d1+2*sm_wall, d2=sm_cut_d2+2*sm_wall, h=sm_h, center=true);
			
			// Leafe tube mounts
			for(i=[0:1:1])mirror([i,0,0])
		  for(j=[0:1:1])mirror([0,j,0])
			translate([sm_base_top_X/2, sm_base_top_Y/2, -sm_wall])
			rotate([-alpha, beta*i, 0])
			translate([0, 0, sm_h/2])
			cylinder(d=sm_d, h=sm_h+11, center=true);
			
			// Enforcements
			for(i=[0:1:1])
			rotate([0, 0, i*90-45])
			cubec([sm_wall, e*2, sm_h*2]);
		}

		// Center hole
//		translate([0, 0, (sm_h+sm_wall)/2])
//		cylinder(d1=sm_cut_d1, d2=sm_cut_d2, h=sm_h+0.1, center=true);
//		cylinder(d=sm_cut_d3, h=sm_wall*2.1, center=true);
		

    // Mount screws on frame
		rotate([0, 0, 22])
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0])
    translate([tc_screw_dis/2, tc_screw_dis/2, 2.5])
    cylinder(d=M3_hole, h=5.1, center=true);


		// Bottom cut
		translate([0,0, -50])
		cubec([sm_base_top_X*2, sm_base_top_Y*2, 100]);
	}
	
}



module arduino_mount(){
  am_w = 60;
  am_l = 100;
  am_wall = 2;
  am_h = 12;
  am_h2 = 6;
  screw_dis = 86.5;
  
  shift_1_Y = 3;
  shift_2_Y = 5;

  difference(){
    union(){
      roundedRect([am_l, am_w, am_wall], 5);
      
      // Mount ponts board
      translate([0, shift_1_Y, 0])
      for(i=[0:1:1])mirror([i, 0, 0])
      translate([screw_dis/2, 0, am_h/2])
      cylinder(d1=13, d2=8, h=am_h, center=true);

      // mount points on lid
      translate([0, shift_2_Y, 0])
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0])
      translate([30, 10, am_h2/2])
      cylinder(d1=15, d2=10, h=am_h2, center=true);
      
    }
    
    // Board mount holes
    translate([0, shift_1_Y, 0])
    for(i=[0:1:1])mirror([i, 0, 0])
    translate([screw_dis/2, 0, am_h/2]){
      cylinder(d=M3_hole, h=am_h+1, center=true);
      translate([0, 0, -2])
      hull(){
        cylinder(d=M3_hole, h=am_h, center=true);
        cylinder(d=M3_nut_e, h=am_h-4, center=true, $fn=6);
      }
    }

    // mount holes on lid
    translate([0, shift_2_Y, 0])
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0])
    translate([30, 10, am_h2/2]){
      cylinder(d=M3_hole, h=am_h2+1, center=true);
      translate([0, 0, 1])
      cylinder(d=M3_nut_e, h=am_h2, center=true, $fn=6);
    }


  }

}




module top_cone(type = 0){
  tc_wall = 2;
  tc_wall2 = 1.4;
  tc_dt = 180;
  tc_db = 20;
  tc_d_out = 10;
  tc_h = 120;
  tc_socket_d = tc_screw_dis*sqrt(2)+15;
  
  lid_h = 20;
  tc_open_d = 40;
  tc_open_X = 55;
    
  // Cone
  if(type == 1)
  difference(){
    union(){
      translate([0, 0, tc_h/2])
      cylinder(d1=tc_db, d2=tc_dt, h=tc_h, center=true);
      // Socket
      translate([0, 0, tc_wall/2])
      cylinder(d=tc_socket_d, h=tc_wall, center=true);
      // Enforcements
      for(i=[0:1:1])rotate([0, 0, i*90])
      translate([0, 0, tc_h/2])
      cubec([tc_socket_d, tc_wall, tc_h]);

      // Mount screws on frame
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0])
      translate([tc_screw_dis/2, tc_screw_dis/2, 2.5])
      cylinder(d1=13, d2=10, h=5, center=true);
    }
    
    // Outlet
    translate([0, 0, tc_wall/2])
    cylinder(d=tc_d_out, h=tc_wall*10.1, center=true);
    
    // Center cut
    translate([0, 0, tc_h/2+4])
    cylinder(d1=tc_db, d2=tc_dt, h=tc_h, center=true);
    
    // Mount screws on frame
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0])
    translate([tc_screw_dis/2, tc_screw_dis/2, 2.5]){
      cylinder(d=M3_hole, h=5.1, center=true);
      translate([0, 0, 2])
      cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
    }
    
  }
  
  // Lid
  if(type == 2)
  difference(){
    translate([0, 0, lid_h/2])
    hull(){
      cylinder(d=tc_dt+2*tc_wall+1, h=lid_h, center=true);
      // Clamp screw mounts
      for(i=[0:120:270])
      rotate([0, 0, i])
      translate([tc_dt/2+10, 0, 0])
      rotate([0, 90, 0])
      roundedRect([lid_h, lid_h, 0.1], 2);
    }
    
    // Center cut
    translate([0, 0, lid_h/2+tc_wall])
    cylinder(d=tc_dt+1, h=lid_h, center=true);

    // Clamp screw cuts
    for(i=[0:120:270])
    rotate([0, 0, i])
    translate([tc_dt/2+10, 0, lid_h/2])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=20, center=true);
      translate([0, 0, -7])
      cylinder(d=M3_nut_e, h=10.2, center=true, $fn=6);
    }

    // Mount holes stepper motor
    translate([0, 0, tc_wall/2])
    cylinder(d=23, h=tc_wall+0.1, center=true);
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_m/2, motor_m/2, tc_wall/2]){
        cylinder(d=M3_hole, h=tc_wall+0.1, center=true);
      }
    }

    // Holes opening
    translate([tc_open_X, 0, 2.5]){
      cylinder(d=tc_open_d, h=5.1, center=true);
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0]){
        translate([tc_open_d/2, tc_open_d/2, 0]){
          cylinder(d=M3_hole, h=5.1, center=true);
        }
      }
    }
    
    // Mount holes Arduino
    ard_X = 0;
    ard_Y = 60;
    translate([ard_X, ard_Y, tc_wall/2])
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0])
    translate([30, 10, 0])
    cylinder(d=M3_hole, h=tc_wall+1, center=true);
  }
  
  // Lid cone
  lc_h = 30;
  lc_d2 = tc_open_d + 20;
  if(type == 3)
  difference(){
    union(){
      roundedRect([tc_open_d+20,tc_open_d+20,tc_wall], 5);
      a = tc_open_d+2*tc_wall;
      b = lc_d2+2*tc_wall;
      translate([0, 0, lc_h/2])
      cylinder(d1=a, d2=b, h=lc_h, center=true);

      // Mount points
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0]){
        translate([tc_open_d/2, tc_open_d/2, 2.5]){
          cylinder(d1=15, d2=10, h=5, center=true);
        }
      }
    }
    
    // Center cut
    translate([0, 0, lc_h/2])
    cylinder(d1=tc_open_d, d2=lc_d2, h=lc_h+0.1, center=true);

    // Mount holes
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([tc_open_d/2, tc_open_d/2, 2.5]){
        cylinder(d=M3_hole, h=5.1, center=true);
        translate([0, 0, 0.5])
        rotate([0, 0, 15])
        cylinder(d=M3_nut_e, h=4.05, center=true, $fn=6);
      }
    }

  }
}


module stepper_clamp(){
  sc_l = 79;
  sc_h1 = 10;
  sc_h2 = 30;
  sc_hs = 10;
  sc_w1 = 84;
  sc_w2 = 10;
  sc_e1 = 20;
  sc_e2 = 15;
  sc_e3 = 5;
  sc_e4 = 18;
  sc_wall = 2;
  sc_shift = (sc_e4 - sc_e2)/2;
  
  // Stepper motor clamp screws
  screw_step_shift = 49-sc_l/2;
  screw_step_dis = 25;
  
  
  // Mount screws on socket
  mss_dis = 20;
  
  // Mount grid on X axis
  mg_X1 = 27-0;
  mg_Y1 = 9.5/2;
  
  // love board mount dimensions
  lbm_l = sc_l-5;
  lbm_h = 55+25;
  lbm_s_Y = 26-sc_l/2;
  lbm_s_Z = 16;
  
  // Front bar dimensions /feeder pipe mount)
  fb_h = 6;
	fb_h2 = 18.5;
  fb_lm = 50;
  fb_l = 10;
  fb_w = sc_w1+20;
  fb_wall = 2;
  
	// Pivot point feeder tube
	front_screw_X = 5;
  pivot_X = 35;
  pivot_Y = fb_lm-5-fb_l/2;
  pivot_Z = fb_h2-3.5;
	pivot_shift_X = 2.5;
	
	// Powder sensor position
	ps_X = 0;
	ps_Y = 60;
//  ps_Z = 0;
//	ps_l = 30;
	
	// Powder guide
	pg_l = 20;
	pg_w = 40;
	pg_h = 8;
	pg_h2 = 20;
  
  // Wire clamp
  wc_l = 50;
  wc_h = 10;
  wc_w = 17;
  wc_screw_dis = 40;
  
//  if(0)
  for(i=[0:1:1])
  translate([0, -i*(wc_w+2)-sc_l/2-3+79*0, wc_h/2])
  rotate([90, 0, 0])
  difference(){
    roundedRect([wc_l, wc_h, wc_w], 3);
    translate([0, 0, wc_w/2+2])
    
    // Center cut
    translate([0, 2, 0])
    cubec([wc_l-20, wc_h, wc_w]);
    translate([0, 0, wc_w/2+5])
    cubec([wc_l-20, wc_h+0.1, wc_w]);
    
    // mount screw cuts
    for(i=[0:1:1])mirror([i,0,0])
    translate([wc_screw_dis/2, 0, wc_w/2]){
      cylinder(d=M3_hole, h=wc_w+0.1, center=true);
      translate([0, 0, -2])
      cylinder(d=M3_nut_e, h=wc_w, center=true, $fn=6);
    }
  }
  
  // Front bar
//  if(0)
  translate([0, sc_l/2+8, 0])
  difference(){
    union(){
      roundedRect([fb_w, fb_l, fb_h], 3);
			roundedRect([fb_w, fb_l, fb_wall], 3);
		
			// Powder guide
			if(0)
			translate([pivot_shift_X, pivot_Y+pg_l/2, 0]){
				translate([0, 0, sc_wall/2])
				cubec([pg_w, pg_l, sc_wall]);
				for(i=[0:1:1])mirror([i,0,0])
				translate([(pg_w-sc_wall)/2, 0, 0])
				hull(){
					translate([0, 0, pg_h/2])
				  cubec([sc_wall, pg_l, pg_h]);
					translate([0, (pg_l-sc_wall)/2, pg_h2/2])
					cubec([sc_wall, sc_wall, pg_h2]);
				}
				
			}
			
			// Powder sensor mount
			Y = pivot_Y+5;
			translate([pivot_shift_X, 0, 0]){
				for(i=[0:1:1])mirror([i,0,0])
				hull(){
					translate([0, Y, 0])
					roundedRect([10, 10, sc_wall], 2);
					translate([pivot_X-fb_l/2, pivot_Y+2.5, 0])
					roundedRect([10, 5, sc_wall], 2);
				}
				hull(){
					translate([0, Y, 0])
					roundedRect([10, 10, sc_wall], 2);
					translate([0, ps_Y, 0])
					roundedRect([10, 10, sc_wall], 2);
				}
			}
			
			// Gimbal pivot mounts
			translate([pivot_shift_X, 0, 0])
		  for(i=[0:1:1])mirror([i,0,0])
			hull(){
        translate([pivot_X-fb_l/2, pivot_Y, 0])
        roundedRect([fb_l, fb_l, fb_h2], 2);
        translate([pivot_X-fb_l/2, 0, 0])
        roundedRect([fb_l, fb_l, fb_h], 2);
			}
    }

    // Cut pivot point feeder pipe
		translate([pivot_shift_X, 0, 0])
    translate([0, pivot_Y, pivot_Z])
		rotate([0, 90, 0]){
		  cylinder(d=M3_hole, h=fb_w+0.1, center=true);
			rotate([0, 0, 30])
			cylinder(d=M3_nut_e, h=pivot_X*2-14, center=true, $fn=6);
		}
    

    // Mount holes on hopper
    for(i=[0:1:1])mirror([i,0,0])
    translate([fb_w/2-5, 0, fb_h/2]){
      cylinder(d=M3_hole, h=fb_h+0.1, center=true);
      translate([0, 0, 7])
      cylinder(d=7, h=fb_h+10, center=true);
    }

    // Stepper adjust screw
    translate([pivot_shift_X, 0, 0]){
			translate([0, 0, fb_h/2])
      cylinder(d=M3_hole, h=fb_h+0.1, center=true);
      hull(){
        cylinder(d=M3_hole, h=10, center=true);
        cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
			}
    }
    
  }

  // Stepper motor clamp
//  if(0)
  difference(){
    union(){
      roundedRect([sc_w1, sc_l, sc_h1], 3, [0,0,0,0]);
      
/*      
      // Force sensor mount plate
      hull(){
        translate([(sc_w1-sc_wall)/2, fs_shift, sc_h2/2])
        cubec([sc_wall, fs_screw_dis_h+10, sc_h2]);
        
        translate([sc_w1/2-sc_wall, 3-sc_l/2, sc_h1-sc_wall])
        cube(size=[sc_wall, sc_wall, sc_wall]);
      }
      // Enforcements fore sensor mount
      translate([sc_w1/2-5, fs_shift, sc_h2/2])
      for(i=[0:1:1])mirror([0,i,0])
      translate([0, fs_screw_dis_h/2, 0])
      cubec([10, 10, sc_h2]);
*/
      
      // Love board mount (right plate)
      translate([(sc_wall-sc_w1)/2, 0, lbm_h/2])
      cubec([sc_wall, sc_l, lbm_h]);
      translate([-5-sc_w1/2, sc_l/2-5, 0])
      roundedRect([10, 10, lbm_h], 2, [1,0,1,0]);

      // Left plate
      translate([(sc_w1-sc_wall)/2, 0, lbm_h/2])
      cubec([sc_wall, sc_l, lbm_h]);
      translate([sc_w1/2+5, sc_l/2-5, 0])
      roundedRect([10, 10, lbm_h], 2, [0,1,0,1]);
      
      // rear plate
      translate([0, (sc_wall-sc_l)/2, lbm_h/2])
      cubec([sc_w1, sc_wall, lbm_h]);
    }
    
    // Love board mount hole
    translate([0, lbm_s_Y, lbm_s_Z])
    rotate([0, 90, 0])
    cylinder(d=M3_hole, h=sc_l*2.1, center=true);
    // Water hose or wires mount holes
    translate([0, sc_l/2-20, lbm_h/2])
    for(i=[0:1:1])mirror([0,0,i])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([0, 5, 10])
      rotate([0, 90, 0])
      cylinder(d=M3_hole, h=sc_l*2.1, center=true);
      translate([0, 5, 20])
      rotate([0, 90, 0])
      cylinder(d=M3_hole, h=sc_l*2.1, center=true);
    }
    
    // Cable mount holes
    translate([0, sc_l/2-20, lbm_h/2+5])
    for(i=[0:1:1])mirror([0,0,i])
    for(j=[0:1:1])mirror([j,0,0]){
      translate([20, 0, 30])
      rotate([90, 0, 0])
      cylinder(d=M3_hole, h=sc_l*2.1, center=true);
      translate([20, 0, 20])
      rotate([90, 0, 0])
      cylinder(d=M3_hole, h=sc_l*2.1, center=true);
    }
    
    
    // Front bar mount holes
    for(i=[0:1:1])mirror([i,0,0])
    translate([sc_w1/2+5, sc_l/2-10, 5])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=20.1, center=true);
      cylinder(d=M3_nut_e, h=16, center=true, $fn=6);
    }
    

    // Mount holes on X axis
    translate([sc_shift, -(sc_l-sc_e1)/2, 0])
    for(no=[0:1:3])
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0])
    translate([mg_X1-7*no, mg_Y1, sc_h1]){
      if(0)
      hull(){
        for(y=[0:1:1])mirror([0,y,0])
        translate([0, 0.7, 0]){
          cylinder(d=6.5, h=sc_h1*2-8, center=true);
        }
      }
      hull(){
        for(y=[0:1:1])mirror([0,y,0])
        translate([0, 0.7, 0]){
          cylinder(d=M3_hole, h=sc_h1*2.1, center=true);
        }
      }
    }


    // Mount holes on socket
    if(0)
    translate([0, -(sc_l-sc_e1)/2, 0])
    for(i=[0:1:1])mirror([i,0,0])
    translate([mss_dis/2, 0, 0]){
      cylinder(d=M3_hole, h=sc_h1*2.1, center=true);
      hull(){
        cylinder(d=M3_hole, h=sc_h1*2-4, center=true);
        cylinder(d=M3_nut_e, h=sc_h1*2-8, center=true, $fn=6);
      }
    }
    
    
    // Inner cut
    translate([sc_shift, (sc_e1-sc_e3)/2+10, -0.05]){
      a = sc_w1 - sc_e2 - sc_e4 + 10;
      b = sc_l - sc_e1 - sc_e3 + 20;
      roundedRect([a, b, sc_h1+0.1], 2);
      hull(){
        roundedRect([a, b, 2], 2);
        roundedRect([a+1, b+1, 0.1], 2);
      }
    }
    
    
    // Stepper clamp screws left/right
    translate([0, screw_step_shift, sc_h1/2])
    for(i=[-1:1:1])
    translate([0, i*screw_step_dis/2, 0])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=sc_w1+0.1, center=true);
      cylinder(d=M3_nut_e, h=sc_w1-6, center=true, $fn=6);
    }
    // Stepper clamp screws front
    translate([0, (sc_l-sc_e3)/2, sc_h1/2])
    for(i=[-1:1:1])
    translate([i*screw_step_dis/2, 0, 0])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=sc_e3+0.1, center=true);
      translate([0, 0, 2])
      cylinder(d=M3_nut_e, h=sc_e3, center=true, $fn=6);
    }
    
/*    
    // Fore sensor mount screws
    translate([10, fs_shift, sc_h2-5])
    for(i=[0:1:1])mirror([0,i,0])
    translate([0, fs_screw_dis_h/2, 0])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=sc_w1-10, center=true);
      cylinder(d=M3_nut_e, h=sc_w1-24, center=true, $fn=6);
    }
*/    
  }
  
}






module cable_mount(){
  cm_l = 7*6 - 2;
  cm_w = 8;
  cm_h = 15;
  cm_h2 = 25;
  cm_wall = 2;
  cm_enforce = 4.5;
  screw_dis = 7 * 4;

  // clamps
  c_l = 19;
  c_w = 8;
  c_h = 3;
  translate([0, -15, 0])
  difference(){
    roundedRect([c_l, c_w, c_h], c_w/2);
    
    for(i=[0:1:1])mirror([i,0,0])
    translate([4.5, 0, c_h/2]) 
    cylinder(d=M3_hole, h=c_h+0.1, center=true);
  }

  // Main part
//  if(0)
  difference(){
    union(){
      translate([0, 0, cm_wall/2])
      cubec([cm_l, cm_h, cm_wall]);
      
      translate([0, (cm_h-cm_wall)/2, cm_enforce/2])
      cubec([cm_l, cm_wall, cm_enforce]);
      
      for(i=[0:1:1])mirror([i,0,0])
      translate([cm_l/2, -(cm_h2-cm_h)/2, cm_w/2])
      rotate([90, 0, 0])
      cylinder(d=cm_w, h=cm_h2, center=true);
      
      brim_d = 10;
      brim_h = 0.35;
      for(i=[0:1:1])mirror([i,0,0])
      translate([cm_l/2, -cm_h2+cm_h/2, brim_h/2])
      cylinder(d=brim_d, h=brim_h, center=true);
      
    }

    for(i=[0:1:1])mirror([i,0,0])
    translate([cm_l/2, 0, cm_w/2])
    rotate([90, 0, 0])
    cylinder(d=M3_hole, h=cm_h2*2.1, center=true);
  }
}



module motor_plate_NEMA17(){
  mp_w = 46;
  mp_w1 = 47;
  mp_l = 2 * motor_mnt_X + 10;
  mp_h = 10;
  mp_h2 = 25;
  mp_wall = 2;
  
	translate([-10, 35, 0])
	spacer(do=10, di=M3_hole, h=20, no=4);
	
  difference(){
    
    
    union(){
      roundedRect([mp_l, mp_w, mp_h], 2.5);

/*      
      // Front 'flaps'
      for(i=[0:1:1])mirror([i,0,0])
      translate([mp_l/2-2.5, (mp_w1-mp_w)/2, 0])
      roundedRect([5, mp_w1, 5], 2.5);
*/
      
      // enforcements
      difference(){
        intersection(){
          roundedRect([mp_l, mp_w, mp_h2], 2.5);
          translate([0, 0, -15])
          rotate([90, 0, 0])
          cylinder(d=80, h=mp_w, center=true);
        }
        roundedRect([mp_l*2, mp_w-10, mp_h2], 2.5, [0,0,0,0]);
        
      }
      
      // Brim
      brim_d = 10;
      brim_h = 0.2;
      for(i=[0:1:1])mirror([i, 0, 0])
      for(j=[0:1:1])mirror([0, j, 0])
      translate([mp_l/2, mp_w/2, brim_h/2])
      cylinder(d=brim_d, h=brim_h, center=true);
    }
    
    // Center cut
    translate([0, 0, mp_h/2])
    cylinder(d=23, h=mp_h+1, center=true);


    translate([0, 0, mp_h+mp_h2/2])
    cubec([motor_e + 0.5, motor_e + 0.5,mp_h2]);
    
    // Mount holes on hopper
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_mnt_X, motor_mnt_Y/2, mp_h/2]){
        cylinder(d=M3_hole, h=mp_h+0.1, center=true);
      }
    }
    
    // Mount holes stepper motor (gearbox)
		
    for(i=[0:1:3])rotate([0,0, i*90+45])
		translate([motor_m_r, 0, mp_h/2]){
		  cylinder(d=M3_hole, h=mp_h+0.1, center=true);
			translate([0, 0, -6])
			hull(){
				cylinder(d=M3_hole, h=mp_h, center=true);
			  cylinder(d=8, h=mp_h-4, center=true);
			}
		}
    
    
  }
}

module motor_plate_printed_gearbox(){
	mp_do = gearbox_do;
	mp_di = 40;
  mp_w = 46;
  mp_w1 = 47;
  mp_l = 2 * motor_mnt_X + 10;
  mp_h = 10;
  mp_h2 = 40;
  mp_wall = 2;
	
	// Bottom plate mount
	bp_screw_r = 18.2;
	bp_wall = 2;

	brim_d = 10;
	brim_h = 0.2;
  
	// Bottom plate
	translate([0, 57, 0])
	difference(){
		union(){
		  roundedRect([mp_l, mp_w, bp_wall], 2.5);
      // Brim
      for(i=[0:1:1])mirror([i, 0, 0])
      for(j=[0:1:1])mirror([0, j, 0])
      translate([mp_l/2, mp_w/2, brim_h/2])
      cylinder(d=brim_d, h=brim_h, center=true);
		}

    // Center cut
    translate([0, 0, bp_wall/2]){
			cylinder(d=bb12_do-2, h=bp_wall+1, center=true);
		}

    // Mount holes on hopper
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0])
		translate([motor_mnt_X, motor_mnt_Y/2, mp_h/2]){
			cylinder(d=M3_hole, h=mp_h+0.1, center=true);
		}
    
    // Bottom plate mount holes
    for(i=[0:1:3])rotate([0,0,i*90+45])
		translate([bp_screw_r, 0, bp_wall/2]){
			cylinder(d1=6, d2=M3_hole, h=bp_wall+0.1, center=true);
		}

    // Mount holes stepper motor (gearbox)
    for(i=[0:1:1])mirror([i,0,0])
		for(j=[0:1:1])mirror([0,j,0])
    translate([print_gear_mnt_X, print_gear_mnt_Y, mp_h2/2]){
			cylinder(d=7, h=mp_h2+0.1, center=true);
		}
	}
	
	// Main part
  difference(){
    union(){
      roundedRect([mp_l, mp_w, mp_h], 2.5);

      // Gearbox ring
			translate([0, 0, mp_h2/2])
			cylinder(d=mp_do, h=mp_h2, center=true);

			// Mount points stepper motor (gearbox)
			for(i=[0:1:1])mirror([i,0,0])
			for(j=[0:1:1])mirror([0,j,0])
				translate([print_gear_mnt_X, print_gear_mnt_Y, mp_h2/2]){
				cylinder(d=12, h=mp_h2, center=true);
			}
      
      // enforcements
      difference(){
        intersection(){
          roundedRect([mp_l, mp_w, mp_h2], 2.5);
          translate([0, 0, -15])
          rotate([90, 0, 0])
          cylinder(d=80, h=mp_w, center=true);
        }
        roundedRect([mp_l*2, mp_w-5, mp_h2], 2.5, [0,0,0,0]);
        
      }
      
      // Brim
      for(i=[0:1:1])mirror([i, 0, 0])
      for(j=[0:1:1])mirror([0, j, 0])
      translate([mp_l/2, mp_w/2, brim_h/2])
      cylinder(d=brim_d, h=brim_h, center=true);
    }
    
    // Center cut
    translate([0, 0, mp_h/2]){
			cylinder(d=bb12_do-2, h=mp_h, center=true);
			translate([0, 0, 1.5])
			hull(){
				cylinder(d=bb12_do-8, h=mp_h, center=true);
				translate([0, 0, -4])
				cylinder(d=bb12_do, h=mp_h, center=true);
			}
		}


    translate([0, 0, mp_h2/2+9.9])
    cylinder(d=mp_di, h=mp_h2, center=true);
    
    // Mount holes on hopper
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_mnt_X, motor_mnt_Y/2, mp_h/2]){
        cylinder(d=M3_hole, h=mp_h+0.1, center=true);
      }
    }
    
    // Bottom plate mount holes
    for(i=[0:1:3])rotate([0,0,i*90+45])
		translate([bp_screw_r, 0, mp_h/2]){
			cylinder(d=M3_hole, h=mp_h+0.1, center=true);
			translate([0, 0, 1])
			rotate([0, 0, 30])
			cylinder(d=M3_nut_e, h=mp_h-2, center=true, $fn=6);
		}

    // Mount holes stepper motor (gearbox)
    for(i=[0:1:1])mirror([i,0,0])
		for(j=[0:1:1])mirror([0,j,0])
      translate([print_gear_mnt_X, print_gear_mnt_Y, mp_h2/2]){
			cylinder(d=M3_hole, h=mp_h2+0.1, center=true);
			translate([0, 0, 25-mp_h2])
			hull(){
        cylinder(d=M3_hole, h=mp_h2, center=true);
				translate([0, 0, -4])
				cylinder(d=7, h=mp_h2, center=true);
			}
		}
    
    
  }
}



module motor_plate_commercial_gearbox(){
  mp_w = 46;
  mp_w1 = 47;
  mp_l = 2 * motor_mnt_X + 10;
  mp_h = 10;
  mp_h2 = 25;
  mp_wall = 2;
  
  difference(){
    
    
    union(){
      roundedRect([mp_l, mp_w, mp_h], 2.5);

/*      
      // Front 'flaps'
      for(i=[0:1:1])mirror([i,0,0])
      translate([mp_l/2-2.5, (mp_w1-mp_w)/2, 0])
      roundedRect([5, mp_w1, 5], 2.5);
*/
      
      // enforcements
      difference(){
        intersection(){
          roundedRect([mp_l, mp_w, mp_h2], 2.5);
          translate([0, 0, -15])
          rotate([90, 0, 0])
          cylinder(d=80, h=mp_w, center=true);
        }
        roundedRect([mp_l*2, mp_w-10, mp_h2], 2.5, [0,0,0,0]);
        
      }
      
      // Brim
      brim_d = 10;
      brim_h = 0.2;
      for(i=[0:1:1])mirror([i, 0, 0])
      for(j=[0:1:1])mirror([0, j, 0])
      translate([mp_l/2, mp_w/2, brim_h/2])
      cylinder(d=brim_d, h=brim_h, center=true);
    }
    
    // Center cut
    translate([0, 0, mp_h/2])
    cylinder(d=20, h=mp_h+1, center=true);

    translate([0, 0, mp_h/2+2])
    cylinder(d=25.5, h=mp_h, center=true);

    translate([0, 0, mp_h2/2+5])
    cylinder(d=43, h=mp_h2, center=true);
    
    // Mount holes on hopper
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_mnt_X, motor_mnt_Y/2, mp_h/2]){
        cylinder(d=M3_hole, h=mp_h+0.1, center=true);
      }
    }
    
    // Mount holes stepper motor (gearbox)
    for(i=[0:1:3])rotate([0,0, i*90+45]){
      translate([gear_mnt_X/2, gear_mnt_Y/2, mp_h/2]){
        cylinder(d=M4_hole, h=mp_h+0.1, center=true);
//        translate([0, 0, (3-mp_h)/2])
//        cylinder(d2=M3_hole, d1=6, h=3.1, center=true);
      }
    }
    
    
  }
}


module fan_mount(){

  fm_w = 30;
  fm_l = 54;
  fm_alpha = -50;
  fm_beta = 0;
  fm_wall = 4;  
      
  // Fan mount flap on hopper
  fmh_l = 65;
  fmh_w = 15;
  
  shift_X = 29;
  shift_Y = 16;
  
  // Magnet screw pos
  msp_X = -11;
  msp_Y = 3;
  msp_Z = 30;
  
  // Hinge screw dimensions and pos
  hs_X = 5-fmh_l/2 + shift_X;
  hs_Y = 2.5 + shift_Y;
  hs_h = 15;
  hs_d = 10;
  
  difference(){
    union(){
      // Lever
      translate([shift_X, shift_Y, 0])
      roundedRect([fmh_l, fmh_w, fm_wall],2);
      
      // Magnet screw mount
      hull(){
        translate([msp_X+shift_X, msp_Y+shift_Y, msp_Z])
        rotate([90, 0, 0])
        cylinder(d=15, h=fm_wall*2, center=true);
        translate([msp_X+shift_X, msp_Y+shift_Y, fm_wall/2])
        cubec([25, fm_wall*2, 0.1]);
      }

      // Hinge screw socket
      translate([hs_X, hs_Y, hs_h/2])
      cylinder(d=hs_d, h=hs_h, center=true);

      
      
      // Mount plate fan
      translate([fmh_l/2, 0, 0])
      rotate([0, fm_beta, fm_alpha])
      translate([0, 16, fm_w/2])
      rotate([0, 90, 0])
      difference(){
        roundedRect([fm_w, fm_l, fm_wall], 5);
        for(i=[0:1:1])mirror([0,i,0])
        translate([-9.5, fm_screw_dis/2, fm_wall/2])
        hull(){
          cylinder(d=M3_hole, h=fm_wall+0.1, center=true);
          translate([14, 0, 0])
          cylinder(d=M3_hole, h=fm_wall+0.1, center=true);
        }
      }

    }
    
    // Magnet screw hole
    translate([msp_X+shift_X, msp_Y+shift_Y, msp_Z])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=fm_wall*2+0.1, center=true);
      translate([0, 0, 5.0])
      cylinder(d=M3_nut_e, h=fm_wall*2, center=true, $fn=6);
    }
    
    
    // make bottom flat
    translate([0, 0, -5])
    cube(size=[200, 200, 10], center=true);
    
    // cut tip
    translate([62.06, 0, 0])
    rotate([0, fm_beta, fm_alpha])
    rotate([0, -90, 0])
    roundedRect([fm_w, fm_l*2, 15], 5);
    
    // Mount screws on hopper
    
		translate([hs_X, hs_Y, hs_h/2]){
			cylinder(d=M3_hole, h=hs_h+0.1, center=true);
			translate([0, 0, hs_h/2])
			cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
			translate([0, 0, -hs_h/2])
			hull(){
				cylinder(d=M3_hole, h=8, center=true);
				cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
			}
		}
//      translate([20-fmh_l/2, 3.5, fm_wall/2])
//      cylinder(d=M3_hole, h=fm_wall+0.1, center=true);
    
  }
}

module fan_nozzle(){
  fn_li = 20+0.2;
  fn_wi = 15+0.5;
  fn_wall1 = 2;
  fn_wall2 = 1;
  fn_wall3 = 3;
  fn_l1 = fn_li + 2 * fn_wall1;
  fn_w1 = fn_wi + 2 * fn_wall1;
  fn_w2 = 35;
  fn_h1 = 15;
  fn_h2 = 15;
  fn_h3 = fn_h2 - 2 * fn_wall2;
  fn_h4 = 3.5;
  fn_h5 = fn_h4 - 2 * fn_wall2;
	fn_h6 = fn_h1 + 53;
  fn_shift_X = 10.9;
  fn_shift_Y = 67;
  fn_angle = 7;
	fan_w = 55;
  fan_shift_X = 30;
	
	// mount screw pos
	screw_1_X = fan_shift_X/2 + 24;
	screw_1_Z = fn_h1 + 1;
  screw_2_X = fan_shift_X/2 - 22;
	screw_2_Z = fn_h1 + 37.4;
	
  translate([0, 0, fn_h1/2])
  difference(){
    union(){
			// rear wall
			translate([0, 8.02, 2])
			hull(){
				rotate([fn_angle, 0, 0])
				translate([-7, 0, -5])
				rotate([90, 0, 0])
				cylinder(d=10, h=fn_wall3, center=true);

				rotate([fn_angle, 0, 0])
				translate([24, 0, -3])
				rotate([90, 0, 0])
				cylinder(d=15, h=fn_wall3, center=true);

				rotate([fn_angle, 0, 0])
				translate([screw_1_X, 0, screw_1_Z])
				rotate([90, 0, 0])
				cylinder(d=10, h=fn_wall3, center=true);

				rotate([fn_angle, 0, 0])
				translate([screw_2_X, 0, screw_2_Z])
				rotate([90, 0, 0]){
					cylinder(d=10, h=fn_wall3, center=true);
					translate([fm_screw_dis, 0, 0])
					cylinder(d=10, h=fn_wall3, center=true);
				}
			}
//			rotate([fn_angle, 0, 0])
//			translate([fan_shift_X/2, fn_l1/2-3.54, fn_h6/2-10.5])
//			cubec([fan_w, fn_wall3, fn_h6]);
			
      // Top box
      translate([0, -sin(fn_angle)*fn_h1/2, 2.4])
      rotate([fn_angle, 0, 0])
      cubec([fn_l1, fn_w1, fn_h1]);
      hull(){
        translate([0, 0, (fn_h2-fn_h1)/2])
        cube(size=[fn_l1, fn_w1, fn_h2], center=true);
        translate([fn_shift_X, fn_shift_Y, (fn_h4-fn_h1)/2])
        cube(size=[fn_w2, 0.1, fn_h4], center=true);
      }
    }
		
		// Bottom flat cut
		translate([0, 0, -10-fn_h1/2])
		cubec([100, 100, 20]);
		
    
    difference(){
      union(){
        translate([0, -sin(fn_angle)*fn_h1/2, 2.4])
        translate([0, 0, fn_wall2])
        rotate([fn_angle, 0, 0])
        cube(size=[fn_li, fn_wi, fn_h1], center=true);
        hull(){
          translate([0, 0, (fn_h2-fn_h1)/2])
          cube(size=[fn_l1-4, fn_w1-2, fn_h3], center=true);
          translate([fn_shift_X, fn_shift_Y, (fn_h4-fn_h1)/2])
          cube(size=[fn_w2-4, 0.15, fn_h5], center=true);
        }
      }
			// Inner walls
      for(i=[-2:1:2])
      hull(){
        translate([4+i*5, fn_wi/2, (fn_h2-fn_h1)/2])
        cube(size=[1,1,fn_h2], center=true);
        translate([fn_shift_X+i*6, fn_shift_Y, (fn_h2-fn_h1)/2])
        cube(size=[1,1,fn_h2], center=true);
      }
    }
    
    // Nozzle tip
//    translate([0, fn_shift_Y, fn_h2-fn_h1/2])
//    cube(size=[fn_li, 6.1, 20.1], center=true);
    
    hull(){
      translate([fn_shift_X, fn_shift_Y, fn_h2-fn_h1/2])
      cube(size=[fn_w2*1.5, 0.1, 0.1], center=true);
      translate([fn_shift_X, fn_shift_Y, -fn_h1/2])
      cube(size=[fn_w2*1.5, 15, 0.1], center=true);
    }
    
    // Mount screws fan
		rotate([fn_angle, 0, 0])
		translate([screw_1_X, 0, screw_1_Z])
		rotate([90, 0, 0])
		cylinder(d=4, h=fn_wi*2.2, center=true);

		rotate([fn_angle, 0, 0])
		translate([screw_2_X, 0, screw_2_Z])
		rotate([90, 0, 0]){
			cylinder(d=4, h=fn_wi*2.2, center=true);
			translate([fm_screw_dis, 0, 0])
			cylinder(d=4, h=fn_wi*2.2, center=true);
		}
  }
  
  
}

module fan_nozzle_prusa(){
  fn_li = 50+0.2;
  fn_wi = 10+0.5;
  fn_wall1 = 2;
  fn_wall2 = 1;
  fn_l1 = fn_li + 2 * fn_wall1;
  fn_w1 = fn_wi + 2 * fn_wall1;
  fn_l2 = 35;
  fn_w2 = 30;
  fn_h1 = 15;
  fn_h2 = 7;
  fn_h3 = fn_h2 - 2 * fn_wall2;
  fn_h4 = fn_h2 - 3.5;
  fn_h5 = fn_h4 - 2 * fn_wall2;
  fn_shift_X = 0;
  fn_shift_Y = 65;
  fn_angle = 10;
  
  translate([0, 0, fn_h1/2])
  difference(){
    union(){
      // Top box
      translate([0, -sin(fn_angle)*fn_h1/2, 2.4])
      rotate([fn_angle, 0, 0])
      cube(size=[fn_l1, fn_w1, fn_h1], center=true);
      hull(){
        translate([0, 0, (fn_h2-fn_h1)/2])
        cube(size=[fn_l1, fn_w1, fn_h2], center=true);
        translate([fn_shift_X, fn_shift_Y, (fn_h4-fn_h1)/2])
        cube(size=[fn_l2, 0.1, fn_h4], center=true);
      }
    }
    
    difference(){
      union(){
        translate([0, -sin(fn_angle)*fn_h1/2, 2.4])
        translate([0, 0, fn_wall2])
        rotate([fn_angle, 0, 0])
        cube(size=[fn_li, fn_wi, fn_h1], center=true);
        hull(){
          translate([0, 0, (fn_h2-fn_h1)/2])
          cube(size=[fn_l1-4, fn_w1-2, fn_h3], center=true);
          translate([fn_shift_X, fn_shift_Y, (fn_h4-fn_h1)/2])
          cube(size=[fn_l2-4, 0.15, fn_h5], center=true);
        }
      }
      for(i=[-2:1:2])
      hull(){
        translate([i*10, fn_wi/2, (fn_h2-fn_h1)/2])
        cube(size=[1,1,fn_h2], center=true);
        translate([i*6, fn_shift_Y, (fn_h2-fn_h1)/2])
        cube(size=[1,1,fn_h2], center=true);
      }
    }
    
    // Nozzle tip
//    translate([0, fn_shift_Y, fn_h2-fn_h1/2])
//    cube(size=[fn_li, 6.1, 20.1], center=true);
    
    hull(){
      translate([0, fn_shift_Y, fn_h2-fn_h1/2])
      cube(size=[fn_li, 0.1, 0.1], center=true);
      translate([0, fn_shift_Y, -fn_h1/2])
      cube(size=[fn_li, 15, 0.1], center=true);
    }
    
    // Mount screw on fan
    rotate([fn_angle, 0, 0])
    for(i=[0:1:1])mirror([i,0,0])
    translate([4.3-fn_li/2, 0, fn_h1/2 - 4])
    rotate([90, 0, 0])
    cylinder(d=4, h=fn_wi*2.2, center=true);
  }
  
  
}



module Z_bar_mount(){
  zbm_l = 57;
  zbm_l2 = 19;
  zbm_w = 60;
  zbm_w2 = 35;
  zbm_h = 15;
  zbm_wall = 2;
  zbm_wall2 = 10;
  
  frame_d = 10.5;


  zbm_shift_X = 16;
  zbm_shift_Y = 28 + 10;

  Z_bar_X = 10 - zbm_w/2;
  Z_bar_Y = zbm_wall2 + zbm_shift_Y -zbm_l/2;
  
  screw_dis = 20;
  screw_Z = 5;
  screw_X1 = Z_bar_X + 16;
  screw_X2 = screw_X1 + screw_dis;
  screw_Y = -zbm_l/2;
  
  
  
  translate([0, 0, zbm_h/2])
  difference(){
    union(){
      roundedCube([zbm_w, zbm_l, zbm_h], 2);

      translate([screw_X1, screw_Y+zbm_wall2/2, screw_Z])
      rotate([90, 0, 0])
      cylinder(d=12, h=zbm_wall2, center=true);
      
      translate([screw_X2, screw_Y+zbm_wall2/2, screw_Z])
      rotate([90, 0, 0])
      cylinder(d=12, h=zbm_wall2, center=true);
    }
    // Main cut
    translate([zbm_w2, zbm_l2, 0])
    cube(size=[zbm_w, zbm_l, zbm_h+0.1], center=true);
    translate([15,50,0])
    rotate([0, 0, 45])
    cube(size=[60,60,zbm_h+0.1], center=true);
    
    // Frame cut
    translate([15, zbm_wall2 + (frame_d-zbm_l)/2, zbm_wall])
    cube(size=[zbm_w, frame_d, zbm_h], center=true);
    
    // Z Bar cut
    translate([Z_bar_X, Z_bar_Y, zbm_wall]){
      cylinder(d=10.2, h=zbm_h, center=true);
      cylinder(d=M3_hole, h=zbm_h*2, center=true);
    }
    // Drive Bar cut
    translate([Z_bar_X+17.5*1.5, Z_bar_Y, zbm_wall]){
      cylinder(d=40, h=zbm_h, center=true);
    }
    
    // Mount screws cut
    translate([screw_X1, screw_Y, screw_Z])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=100, center=true);
      translate([0, 0, 5-zbm_wall2/2])
      cylinder(d=7, h=zbm_wall2, center=true);
    }

    translate([screw_X2, screw_Y, screw_Z])
    rotate([90, 0, 0]){
      cylinder(d=M3_hole, h=60, center=true);
      translate([0, 0, 5-zbm_wall2/2])
      cylinder(d=7, h=zbm_wall2, center=true);
    }
  }
}


module X_Axis(type = 1){
  xa_bar_z = 10;
  xa_bar_y = -6;
  xa_bar_shift = -1;
  xa_bar_l = 370;
  xa_l = 95;
  xa_w = 48;
  xa_h = 38;

  bar_shift_Y = 2.0;
  
  Z_bar_X = 0;  
  Z_bar_Y =  bar_shift_Y-10;
  Z_bar_Z = xa_bar_z + 15;
  
  D_bar_X = 0;  
  D_bar_Y = Z_bar_Y + 17.5 + bar_shift_Y;
  D_bar_Z = Z_bar_Z;
  
  xa_bar_dx = 20;
  xa_bar_dy = 15;
  
  // Stepper mount position
  sm_X = -25.5;
  sm_Y = -46;
  sm_Z = xa_bar_z;
  sm_h = 14;
  sm_l = 42;
  sm_w = 55;
  sm_shift_Y = 3;
  
  // Lead nut dimensions
  ln_d = 13.5;
  ln_m_d = 19.5;
  ln_m_a = sqrt((ln_m_d/2)*(ln_m_d/2)/2);
  
  // Belt cut dimensions
  bc_d = 20;
  bc_w = 12;
  
  // Pulley position
  p_Y = 10;
  
  
  // Distance screws 10mm bearing fixture
  s_dis = 31;
  
//  if(0)
  difference(){
    union(){
      translate([0, 0, xa_h/2])
      roundedCube([xa_l, xa_w, xa_h],3);
      if(type == 1)
      translate([sm_X, sm_Y+sm_shift_Y, sm_h/2])
      roundedCube([sm_l, sm_w, sm_h],2);
    }
    
    // belt cut
    translate([sm_X, sm_Y, sm_Z])
    hull(){
      cylinder(d=bc_d, h=bc_w, center=true);
      translate([0, 200, 0])
      cylinder(d=bc_d, h=bc_w, center=true);
    }
    
    // Pulley cut
    difference(){
      translate([sm_X, p_Y, sm_Z])
      cylinder(d=M3_hole, h=bc_w+20, center=true);
      translate([sm_X, p_Y, sm_Z+bc_w/2])
      cylinder(d=6, h=.40, center=true);
    }
    translate([sm_X, p_Y, sm_Z-bc_w/2])
    cylinder(d=M3_nut_e, h=5, center=true, $fn=6);
    
    // Stepper motor cuts
    translate([sm_X, sm_Y, sm_h/2]){
      hull(){
        translate([0, -5, 0])
        cylinder(d=bc_d, h=sm_h+0.1, center=true);
        translate([0, +5, 0])
        cylinder(d=bc_d, h=sm_h+0.1, center=true);
      }
      hull(){
        translate([0, -5, -sm_h/2])
        cylinder(d=23, h=3, center=true);
        translate([0, +5, -sm_h/2])
        cylinder(d=23, h=3, center=true);
        translate([0, -5, 3-sm_h/2])
        cylinder(d=bc_d, h=1, center=true);
        translate([0, +5, 3-sm_h/2])
        cylinder(d=bc_d, h=1, center=true);
      }
      
      for(i=[0:1:1])mirror([i,0,0])
      for(j=[0:1:1])mirror([0,j,0])
      translate([motor_m/2, motor_m/2, 0])
      hull(){
        translate([0, -5, 0])
        cylinder(d=M3_hole, h=sm_h+0.1, center=true);
        translate([0, 5, 0])
        cylinder(d=M3_hole, h=sm_h+0.1, center=true);
      }
    }

    // Drive rod cut
    difference(){
      union(){
        translate([D_bar_X, D_bar_Y, D_bar_Z])
        rotate([0, 90, 0]){
          cylinder(d=ln_d, h=xa_l+0.1, center=true);
          translate([-8.5, 15, 12])
          cube(size=[30, 27.75, xa_l], center=true);
        }
      }
      translate([Z_bar_X, Z_bar_Y, Z_bar_Z])
      for(i=[-s_dis:s_dis:s_dis])
      translate([i+1, 2+lm10luu_do/2, 0]){
        difference(){
          cylinder(d=8, h=xa_h*2, center=true);
//          translate([0, 0, 0.11])
//          cylinder(d=M3_hole+2, h=4.2, center=true);
        }
      }
    }      
    
    
    // Z axis cut
    translate([Z_bar_X, Z_bar_Y, Z_bar_Z]){
        translate([0, -10, 20])
        cube(size=[xa_l+0.1,40,40], center=true);
        translate([12, 0, 20])
        cube(size=[xa_l,60,40], center=true);
      difference(){
        rotate([0, 90, 0])
        cylinder(d=lm10luu_do, h=xa_l+0.1, center=true);
//        for(i=[-(lm10luu_l+5):lm10luu_l+5:lm10luu_l+5])
//        translate([i, 0, -lm10luu_do/2])
//        cube(size=[2, lm10luu_do, 5], center=true);
      }

      // Flex hinge cut
//      hull(){
//        translate([0, lm10luu_do/2+2, xa_h/2])
//        cube(size=[xa_l+0.1, 0.2, xa_h], center=true);
//        translate([0, lm10luu_do/2+2, xa_h-Z_bar_Z])
//        cube(size=[xa_l+0.1, 3, 0.1], center=true);
//      }
      // large gap
//      difference(){
//        translate([0, 0.7-10, -2])
//        union(){
//          roundedRect([xa_l-3.0, 12, 4], 3);
//          translate([0, 0, 2])
//          cube(size=[xa_l-10, 20, 4], center=true);
//        }
//
//        translate([0, -lm10luu_do/2, 0])
//          for(i=[-xa_l/2:10:xa_l/2])
//          translate([i, 0, 0])
//          cube(size=[0.9, lm10luu_do, 4], center=true);
//      }
      
      // Screw holes
      for(i=[0:1:1])mirror([0,i,0])
      for(i=[-s_dis:s_dis:s_dis])
      translate([i+1, -2-lm10luu_do/2, 0]){
        difference(){
          union(){
            cylinder(d=M3_hole, h=xa_h*2, center=true);
            translate([0, 0, -Z_bar_Z])
            hull(){
              cylinder(d=M3_nut_e, h=41, center=true, $fn=6);
              cylinder(d=M3_hole, h=45, center=true);
            }
            translate([0, 0, xa_h-Z_bar_Z])
            cylinder(d=M3_nut_e, h=18, center=true);
          }
          if(i<0)
          translate([0, 0, sm_Z+bc_w/2-Z_bar_Z])
          cylinder(d=20, h=0.4, center=true);
        }
      }

      

    }
    
    if(1==2)
    for(i=[-40:20:40])translate([i, 0, 0])
    if(i!=-20){    
      translate([Z_bar_X, Z_bar_Y, Z_bar_Z/2])
      cylinder(d=M3_hole, h=Z_bar_Z+0.1, center=true);
      translate([Z_bar_X, Z_bar_Y, Z_bar_Z-4])
      cylinder(d=M3_nut_e, h=lm10luu_do, center=true, $fn=6);
    }

    // Weight cut
    c_h = 18.1;
    translate([10, 12.25, c_h/2])
    hull(){
      cube(size=[30, 1, c_h+10], center=true);
      translate([0, 21, 0])
      cube(size=[45, 1, c_h+10], center=true);
      translate([0, 0, -c_h/2])
      cube(size=[30, 40, 0.1], center=true);
    }
    
    // Lead nut cuts
    translate([-xa_l/2, D_bar_Y, D_bar_Z]){
      translate([0, ln_m_a, ln_m_a])
      rotate([0, 90, 0])
      cylinder(d=M3_hole, h=70, center=true);

      translate([0, -ln_m_a, -ln_m_a])
      rotate([0, 90, 0])
      cylinder(d=M3_hole, h=70, center=true);
      
      hull(){
        translate([4, ln_m_a, ln_m_a])
        rotate([0, 90, 0])
        rotate([0, 0, 45+30])
        cylinder(d=M3_nut_e, h=3, center=true, $fn=6);

        translate([4, -ln_m_a, -ln_m_a])
        rotate([0, 90, 0])
        rotate([0, 0, 45+30])
        cylinder(d=M3_nut_e, h=3, center=true, $fn=6);
      }
    }

    
    // X axis rail cuts
    translate([xa_bar_shift, 0, 0])
    for(i=[0:1:1])mirror([i,0,0]){
      // X axis rails
      translate([xa_bar_dis/2, xa_w/2+xa_bar_y, xa_bar_z])
      rotate([90, 0, 0]){
        cylinder(d=xa_bar_d, h=xa_w, center=true);
        cylinder(d=M3_nut_e, h=xa_w+16, center=true, $fn=6);
      }

      // Adjust rod position screws
      translate([xa_bar_dis/2, 0, xa_bar_z])
      rotate([90, 0, 0])
      cylinder(d=M3_hole, h=xa_w, center=true);

      // Rail pos control holes
      translate([xa_bar_dis/2, xa_bar_y, xa_bar_z/2])
      cylinder(d=3, h=xa_bar_z+0.1, center=true);

      // Fix rail screws
      translate([xa_bar_dis/2, xa_w/2-5, xa_bar_z/2])
      cylinder(d=3, h=xa_bar_z+0.1, center=true);
      translate([xa_bar_dis/2, xa_w/2-5, 5])
      rotate([0, 0, 30])
      cylinder(d=M3_nut_e, h=6, center=true, $fn=6);

    }
  }
  
  // 10mm bearing fixture
  f_l = xa_l-15;
  f_w = 30;
  f_h = lm10luu_do/2+4;
  
  translate([5, 42, f_h/2])
  difference(){
    union(){
      roundedCube([f_l, f_w, f_h],3.5);
      // Screw holes
      for(i=[0:1:1])mirror([0,i,0])
      for(i=[-s_dis:s_dis:s_dis])
      translate([i-5.5, -2-lm10luu_do/2, 0]){
        cylinder(d=7, h=f_h, center=true);
      }
    }
    translate([0, 0, f_h/2+4])
    rotate([0, 90, 0])
    cylinder(d=lm10luu_do, h=f_l+0.1, center=true);

    // Screw holes
    for(i=[0:1:1])mirror([0,i,0])
    for(i=[-s_dis:s_dis:s_dis])
    translate([i-5.5, -2-lm10luu_do/2, 0]){
      cylinder(d=M3_hole, h=xa_h*2, center=true);
    }
  }
  
  
}




module force_sensor_mount(){
  fsm_l = 27;
  fsm_l2 = 25;
  fsm_w = 16;
  fsm_w2 = 14;
  fsm_h = 6;
  fsm_h2 = 4;
  fsm_shift_Y = 6;
  s_dis_X = 10;
  
  
  // Spacer to hopper
  translate([20, 0, 0])
  difference(){
    translate([0, 0, 0])
    roundedRect([fsm_w2, fsm_l2, fsm_h2], 5);

    // Force sensor screws
    translate([0, hbm_dis/2, fsm_h2/2])
    cylinder(d=M5_hole, h=fsm_h2+0.1, center=true);
    translate([0, -hbm_dis/2, fsm_h2/2])
    cylinder(d=M5_hole, h=fsm_h2+0.1, center=true);
  }
  
  // Mount on X-Axis
  translate([0, 0, fsm_h/2])
  difference(){
    cube(size=[fsm_w, fsm_l, fsm_h], center=true);
    
    // Force sensor screws
    translate([0, hbm_dis/2, 0])
    cylinder(d=M4_hole, h=fsm_l*2.1, center=true);
    translate([0, -hbm_dis/2, 0])
    cylinder(d=M4_hole, h=fsm_l*2.1, center=true);
    
    // Screw cuts
    for(j=[0:1:1])mirror([j, 0, 0])
    translate([s_dis_X/2, 0, 0])
    rotate([90, 0, 0])
    cylinder(d=M3_hole, h=fsm_l+0.2, center=true);
  }
  
}


module extruder_mount(type = 0){
  em_wall = 2;
  em_w1 = 64;
  em_w2 = 30;
  em_h = xa_bar_dis + 2 * em_wall + lm8uu_do;
  em_thick = em_wall + lm8uu_do/2 - 0.2 * type;
  em_cut_w = 20;
  em_cut_h = 63;
  em_cut_shift = -.0;
  

  // Belt mount
  bm_X1 = -18;
  bm_Y1 = xa_bar_dis/2 - 11 + type * 1.25;

  bm_X2 = 18;
  bm_Y2 = xa_bar_dis/2 - 9.75 - type * 1.25;

  // Cable mount
  cm_X1 = 27;
  cm_X2 = 20;
  cm_Y1 = em_h/2+10;
  cm_Z1 = em_thick/2;
  cm_h = 17;
  cm_do = 15;
  
  // Mount screws grid
  m_grid_dX = 10;
  m_grid_dY = 10;

  // Ball bearing mounts
  a = lm8uu_do + 2 * em_wall;
  bb_screw_X1 = -27;
  bb_screw_X2 = -5;
  bb_screw_X3 = 5;
  bb_screw_X4 = 27;
  bb_screw_Y1 = xa_bar_dis/2 - 10;
  bb_screw_Y2 = xa_bar_dis/2 + 10;
  
  difference(){
    union(){
//      if(type == 0)
      roundedRect([em_w1, em_h, em_wall*2], 2);
      
      // Cable mount
      translate([0, cm_Y1-7, 0])
      roundedRect([em_w1, cm_h, em_thick], 2, [0, 0, 1, 1]);
      
      
      // Ball bearing mounts
      translate([0, -xa_bar_dis/2, 0])
      roundedRect([em_w1, a, em_thick], 2);
      translate([0, xa_bar_dis/2, 0]){
        roundedRect([em_w2, a, em_thick], 2);
        roundedRect([em_w1, 14, em_thick], 2);
      }
      
      // Ball bearing screws
      for(i=[0:1:1])mirror([0, i, 0]){        
        if(i==1)
        hull(){
          translate([bb_screw_X1, bb_screw_Y1, em_thick/2])
          cylinder(d=10, h=em_thick, center=true);
          translate([bb_screw_X1, bb_screw_Y2, em_thick/2])
          cylinder(d=10, h=em_thick, center=true);
        }

        translate([0, 0, em_thick/2])
        hull(){
          translate([bb_screw_X2, bb_screw_Y1+i*5, 0])
          cylinder(d=10, h=em_thick, center=true);
          translate([bb_screw_X2, bb_screw_Y2, 0])
          cylinder(d=10, h=em_thick, center=true);
        }

        translate([0, 0, em_thick/2])
        hull(){
          translate([bb_screw_X3, bb_screw_Y1+i*5, 0])
          cylinder(d=10, h=em_thick, center=true);
          translate([bb_screw_X3, bb_screw_Y2, 0])
          cylinder(d=10, h=em_thick, center=true);
        }

        if(i==1)
        hull(){
          translate([bb_screw_X4, bb_screw_Y1, em_thick/2])
          cylinder(d=10, h=em_thick, center=true);
          translate([bb_screw_X4, bb_screw_Y2, em_thick/2])
          cylinder(d=10, h=em_thick, center=true);
        }
      }
    }
    
    // Top mount points
    for(j=[0:7:21])
    for(i=[0:1:1])mirror([i,0,0]){
      translate([cm_X1-j, cm_Y1, cm_Z1])
      rotate([90, 0, 0])
      cylinder(d=M3_hole, h=cm_h + 0.1, center=true);
      translate([cm_X1-j, cm_Y1-3, 0]){
        hull(){
          cube(size=[5.65, 3.2, cm_Z1*2], center=true);
          translate([0, 0, cm_Z1+0.2])
          rotate([90, 0, 0])
          rotate([0, 0, 30])
          cylinder(d=M3_nut_e, h=3.2, center=true, $fn=6);
        }
      }
    }
    
    // Belt mounts
    translate([bm_X1, bm_Y1, 2])
    cylinder(d=M3_hole, h=em_thick, center=true);
    if(type == 0)
    translate([bm_X1, bm_Y1, 0])
    hull(){
      cylinder(d=M3_hole, h=4, center=true);
      cylinder(d=M3_nut_e, h=2, center=true, $fn=6);
    }

    translate([bm_X2, bm_Y2, 2])
    cylinder(d=M3_hole, h=em_thick, center=true);
    if(type == 0)
    translate([bm_X2, bm_Y2, 0])
    hull(){
      cylinder(d=M3_hole, h=4, center=true);
      cylinder(d=M3_nut_e, h=2, center=true, $fn=6);
    }

    // Mount screws grid
    for(i=[-2:1:3])
    for(j=[-2:1:2])
    translate([i*m_grid_dX-5, j*m_grid_dY, em_thick/2]){
      cylinder(d=M3_hole, h=em_thick+1, center=true);
      translate([0, 0, 4-em_thick/2])
      cylinder(d=M3_nut_e, h=4, center=true, $fn=6);
    }

    // Hopper cut
    translate([0, em_cut_shift, em_thick/2])
    cube([em_cut_w, em_cut_h, em_thick+1], center=true);

    // Ball bearing mount screws
    for(i=[0:1:1])mirror([0, i, 0]){
      if(i==1)
      translate([bb_screw_X1, bb_screw_Y1, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      translate([bb_screw_X1, bb_screw_Y2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }

      translate([bb_screw_X2, bb_screw_Y1, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      translate([bb_screw_X2, bb_screw_Y2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }

      translate([bb_screw_X3, bb_screw_Y1, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      translate([bb_screw_X3, bb_screw_Y2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      // Extra hole on bottom for force sensor mount
      if(i && type == 0)
      translate([0, xa_bar_dis/2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        rotate([0, 0, 30])
        cylinder(d=M3_nut_e, h=em_thick-2, center=true, $fn=6);
      }


      if(i==1)
      translate([bb_screw_X4, bb_screw_Y1, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
      translate([bb_screw_X4, bb_screw_Y2, em_thick/2]){
        cylinder(d=M3_hole, h=em_thick+0.1, center=true);
        if(type==0)
        translate([0, 0, -em_thick/2])
        hull(){
          cylinder(d=M3_hole, h=12, center=true);
          cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
        }
      }
    }

    // X axis bars
    for(i=[0:1:1])mirror([0, i, 0])
    translate([0, xa_bar_dis/2, em_thick])
    rotate([0, 90, 0])
    cylinder(d=xa_bar_d+1, h=em_w1+0.1, center=true);
    // X axis ball bearings
    b = (em_w1-lm8uu_l)/2-2*em_wall;
    for(j=[0:1:1])mirror([j, 0, 0])
    translate([b, -xa_bar_dis/2, em_thick])
    rotate([0, 90, 0])
    cylinder(d=lm8uu_do, h=lm8uu_l+1, center=true);

    translate([0, xa_bar_dis/2, em_thick])
    rotate([0, 90, 0])
    cylinder(d=lm8uu_do, h=lm8uu_l+1, center=true);

  }
}

module water_cooling_drill_template(){
	wc_bar_h = 15;
	wc_bar_w = 20.5;
	wcdt_l = 60;
	wcdt_wall = 5;
	wcdt_w = wc_bar_w + 2 * wcdt_wall;
	wcdt_h = wc_bar_h + wcdt_wall;
	shift = 1.0;
	
//	wedge_h = 1.6;
	wedge_h = 2.2;
	wedge_s_h = 1;
	
  if(0)
  for(no=[0:1:1])
	translate([0, 30+no*22, 0])
	difference(){
		hull(){
  	  translate([0, wc_bar_w/2, (wedge_s_h + wedge_h)/2])
			cubec([wcdt_l, 0.1, wedge_h+wedge_s_h]);
  	  translate([0, -wc_bar_w/2, wedge_s_h/2])
			cubec([wcdt_l, 0.1, wedge_s_h]);
		}
		cylinder(d=12, h=50, center=true);

		// Mount holes on hopper
		for(i=[0:1:1])mirror([i,0,0])
		translate([motor_mnt_X, 0, 0])
		cylinder(d=M3_hole, h=wcdt_h+1, center=true);
		
		if(no){
			cubec([40, 40, 40]);
		}
	}
	
//	if(0)
	translate([0, 0, wcdt_h/2])
	difference(){
	  cubec([wcdt_l, wcdt_w, wcdt_h]);
		translate([0, 0, wcdt_wall])
		cubec([wcdt_l+1, wc_bar_w, wcdt_h]);
		
		// Bar edge cuts
		for(i=[0:1:1])mirror([0,i,0])
		translate([0, wc_bar_w/2-0.5, wcdt_h/2-wc_bar_h+0.5])
		rotate([0, 90, 0])
		cylinder(d=2, h=wcdt_l+1, center=true);

		// Extruder tube hole
		cylinder(d=3, h=wcdt_h+1, center=true);
		
		// Mount holes on hopper
		translate([shift, 0, 0])
		for(i=[0:1:1])mirror([i,0,0])
		translate([motor_mnt_X, 0, 0])
		cylinder(d=3, h=wcdt_h+1, center=true);
		
		// Water cooling holes
		for(i=[0:1:1])mirror([i,0,0])
		translate([10, 0, (wcdt_h-wc_bar_h)/2])
		rotate([90, 0, 0])
		cylinder(d=3, h=wcdt_w+1, center=true);

		// Mount holes extruder
		translate([0, 0, (wcdt_h-wc_bar_h)/2])
		for(i=[0:1:1])mirror([i,0,0])
		for(j=[0:1:1])mirror([0,0,j])
		translate([4, 0, 4])
		rotate([90, 0, 0])
		cylinder(d=3, h=wcdt_w+1, center=true);
		
	}
	
	
}



module hopper_spacer_bottom(){

  // spacer dimensions
  hs_l = 77;
  hs_l2 = 30;
  hs_h = 10;
  
  

  rotate([180, 0, 0])
  difference(){
    union(){

      // Center
      translate([0, 0, hs_h/2])
      cylinder(d=26, h=hs_h, center=true);
      roundedRect([15, hs_l, hs_h], 5);

      // Mount points motor
      for(j=[0:1:1])mirror([0,j,0]){
        translate([motor_mnt_Y ,motor_mnt_X, hs_h/2])
        cylinder(d=20, h=hs_h, center=true);
      }      
    }
    
    
    // Center cut
		translate([0, 0, hs_h/2])
    cylinder(d=14.0, h=hs_h+1, center=true);
    
        
    // Mount holes motor
    for(j=[0:1:1])mirror([0,j,0])
		translate([motor_mnt_Y, motor_mnt_X, hs_h/2]){
			cylinder(d=M3_hole, h=hs_h+0.1, center=true);
		}
    
  }

}




module hopper_front_door(){
  hfd_wall = 2;
  hfd_flap = 65;
	hfd_flap2 = 61.8;
	hfd_flap3 = 20;
  hfd_angle = 20;
  hfd_cut_Z = 11.8;
  hfd_cut_Y = 14;
	hfd_h = h_h + hfd_cut_Y-1;
	hfd_shift = -hfd_cut_Y/2;
  
	// Door dimensions
	d_w = h_wb-1.9;
	d_l1 = 37;
	d_flap_l = 5;
	d_angle = 95;
	d_h = 55;
	
	// clamp dimensions
	c_wall = 1.5;
	c_d1 = 15;
	c_d2 = c_d1-2*c_wall;
	c_l = 17;
	c_h = 7;
	c_gap = 3;
	
	// Clamp
	if(0)
	translate([-40, 50, 0])
	for(i=[0:1:3])
	translate([0, -i*17, c_h/2])
//	scale([1.5,1,1])
	difference(){
		union(){
		  cylinder(d=c_d1, h=c_h, center=true);
			
			for(i=[-1:2:1])rotate([0, 0, i*30])
			translate([-c_l/2, 0, 0])
			cubec([c_l/2, c_wall, c_h]);
		}
		cylinder(d=c_d2, h=c_h+1, center=true);
		
		translate([c_d1/2, 0, 0])
		cubec([c_d1, c_gap, c_h+1]);
	}
	
	
	// Door
//	if(0)
	translate([0, 49-30*0, 35*0])
	rotate([0*(-90+hfd_angle+5), 0, 0]){
		difference(){
			union(){
				translate([0, 0, hfd_wall/2])
				cubec([d_w, d_l1, hfd_wall]);
				
				
				translate([0, d_l1/2, 0])
				rotate([d_angle, 0, 0])
				translate([0, d_h/2, 0])
				cubec([d_w, d_h, hfd_wall]);
				
				for(i=[0:1:1])mirror([i,0,0]){
					hull(){
						translate([0, d_l1/2, 0])
						rotate([d_angle, 0, 0])
						translate([(d_w-hfd_wall)/2, d_h/2, d_flap_l/2])
						cubec([hfd_wall, d_h, d_flap_l]);
						
						translate([(d_w-hfd_wall)/2, 0, hfd_wall/2])
						cubec([hfd_wall, d_l1, hfd_wall]);
					}
					
					hull(){
						translate([0, d_l1/2, 0])
						rotate([d_angle, 0, 0])
						translate([d_w/2+2.5, d_h, d_flap_l/2])
						sphere(d=10);
						
						translate([d_w/2+2.5, -d_l1/2, hfd_wall/2])
						sphere(d=10);
					}
					
				}
			}

      // Slit cut
			for(i=[0:1:1])mirror([i,0,0])
			translate([d_w/2+2, 9, 0])
			hull(){
				translate([0, d_l1/2, 0])
				rotate([d_angle, 0, 0])
				translate([0, d_h, d_flap_l/2])
				cubec([4, 15, 10]);
				
				translate([0, -d_l1/2-4, hfd_wall/2])
				cubec([4, 10, 10]);
			}

			// top cut
			translate([0, 0, d_h+20])
			cubec([d_w+20, d_l1+20, 40]);

			// bottom cut
			translate([0, 0, -20])
			cubec([d_w+20, d_l1+20, 40]);
		}
	}
	
	// Support Main part
	s_wall = 0.5;
	if(0)
	difference(){
		for(i=[0:1:1])mirror([i,0,0]){
			translate([(h_wb+hfd_wall+s_wall)/2, (hfd_h-hfd_cut_Y)/2, hfd_cut_Z/2])
			cubec([s_wall, hfd_cut_Y, hfd_cut_Z]);
			translate([(h_inner_cyl+s_wall)/2, (hfd_h-hfd_cut_Y)/2, hfd_cut_Z/2])
			cubec([s_wall, hfd_cut_Y, hfd_cut_Z]);
			
			a = (h_wb+hfd_wall-h_inner_cyl)/2;
  		for(i=[0:1:4])
			translate([(h_inner_cyl + a)/2, (hfd_h-s_wall)/2-i*3, hfd_cut_Z/2])
			cubec([a, s_wall, hfd_cut_Z]);
		}
		translate([0, hfd_h/2-hfd_cut_Y, hfd_cut_Z/2])
		cubec([h_wb*1.5, s_wall*2, hfd_cut_Z-.6]);
	}
	
	
	// Main part
	if(0)
  difference(){    
    union(){
      roundedRect([h_wb, hfd_h, hfd_wall], 2, [0,0,0,0]);
			ca = hfd_cut_Y + hfd_wall;
			cb = hfd_cut_Z + hfd_wall;
			translate([0, (hfd_h-ca)/2, cb/2])
			cubec([h_wb, ca, cb]);
      
      
      a=cos(hfd_angle)*hfd_flap+0.9;
      b=1-h_h/2-sin(hfd_angle)*hfd_flap;

      // flap
			translate([0, -(hfd_h-hfd_wall)/2, hfd_flap3/2])
			cubec([h_wb, hfd_wall, hfd_flap3]);
//			if(0)
      hull(){
          translate([0, b-(5-hfd_wall/2)-0.05, a])
          cubec([h_wb, hfd_wall, 0.1]);
          translate([0, -(hfd_h-hfd_wall)/2, 20])
          cubec([h_wb, hfd_wall, 0.1]);
      }
      
      // flap walls
      for(i=[0:1:1])mirror([i,0,0]){
				translate([(h_wb-hfd_wall)/2+1.51, 0, hfd_flap2/2])
				cubec([hfd_wall, hfd_h, hfd_flap2]);
				hull(){
					translate([(h_wb-hfd_wall)/2+1.51, 0, 0]){
						translate([0, b+2.5, a])
						cubec([hfd_wall, 15.1, 0.1]);
						translate([0, 0, hfd_flap2])
						cubec([hfd_wall, hfd_h, 0.1]);
						translate([0, 0, hfd_flap3])
						cubec([hfd_wall, hfd_h, 0.1]);
					}
				}
			}
    }

    
		translate([0, (hfd_h-hfd_cut_Y)/2+0.05, hfd_cut_Z/2-0.05])
		cubec([h_wb+10, hfd_cut_Y+0.1, hfd_cut_Z+0.1]);
    
    // Mount screw cuts
		translate([0, hfd_shift, 0])
    for(i=[0:1:1])mirror([i,0,0]){
      translate([mag_X2, mag_Y2, hfd_wall/2])
      cylinder(d=M3_hole, h=hfd_wall+0.1, center=true);
      translate([mag_X3, mag_Y3, hfd_wall/2])
      cylinder(d=M3_hole, h=hfd_wall+0.1, center=true);
    }
    
    // Door cut
    translate([0, 3, hfd_flap/2])
    cubec([h_inner_cyl, hfd_h, hfd_flap + 0.1]);

    
    // mount hole for front feeding cone
//    translate([0, 0, ffc_Y])
//    rotate([0, 90, 0])
//    cylinder(d=M3_hole, h=h_wb*1.5, center=true);
    
    // Mount screws cut
    for(i=[0:1:1])mirror([i,0,0])
    translate([hfd_screw_dis/2, 0, hfd_wall/2])
    cylinder(d=M3_hole, h=hfd_wall+0.1, center=true);
  }
}

module hopper_rear_mount(type = 0){
  
  hrm_w = 19;
  hrm_h1 = 25;
  hrm_h2 = hrm_h1 + 15;
  hrm_l = 75;
  hrm_wall = 3.75;
  hrm_cut_l = 30;
  
  screw_h = hrm_h1 + 10;
  screw_shift = 36-(hrm_l-fs_screw_dis_m)/2;
  
  
  difference(){
    union(){
      translate([0, 0, hrm_h1/2])
      cubec([hrm_l, hrm_w, hrm_h1]);
      
      for(i=[0:1:1])mirror([0,i,0])
      translate([hrm_cut_l/2, hrm_w/2, hrm_h2/2])
      rotate([90, 0, 0])
      roundedRect([hrm_l-hrm_cut_l, hrm_h2, hrm_wall], 5);
    }
    
    // Mount holes force sensor
    translate([screw_shift, 0, 0])
    for(i=[0:1:1])mirror([i,0,0]){
      
      translate([fs_screw_dis_m/2, (hrm_w-hrm_wall)/2, screw_h])
      rotate([90, 0, 0]){
        cylinder(d=M3_hole, h=hrm_wall+0.1, center=true);
        translate([0, 0, -0.75])
        cylinder(d1=6, d2=M3_hole, h=3+0.1, center=true);
      }

      translate([fs_screw_dis_m/2, -(hrm_w-hrm_wall)/2, screw_h])
      rotate([90, 0, 0])
      cylinder(d=M3_nut_e, h=hrm_wall+0.1, center=true, $fn=6);
    }
    
    // Mount holes on X axis
    for(i=[0:1:1])mirror([0,i,0])
    translate([0, 5, 4])
    rotate([0, 90, 0])
    cylinder(d=M3_hole, h=hrm_l+0.1, center=true);
    
    translate([0, 0, 14])
    rotate([0, 90, 0])
    cylinder(d=M3_hole, h=hrm_l+0.1, center=true);
    
    // Cut some space for hopper
    translate([(hrm_cut_l-hrm_l)/2-0.1, 0, hrm_h1-2])
    roundedRect([hrm_cut_l, hrm_w*2, hrm_h2], 2, [0,0,0,0]);
  }
  
}



module hopper(brim = false){
  auger_cut = 12;
  h_shift_Y = -6;
  
  // Tray dimensions
  tray_tol = 1;
  tray_s_Y1 = -h_wb/2+2;
  tray_s_Y2 = tray_s_Y1;
  tray_s_Z1 = h_h/2-7.5;
  tray_s_Z2 = h_h-7.5;
  tray_shift_Z = 5;
  tray_w = h_inner_cyl;
  tray_l = h_lb/2-3;
  
  // Force sensor mount  
  lever_h = 2;
  lever_l = 32;
  lever_w = 18.5;
  
//  translate([0, 40, 29])cubec([10,10,10]);
  
  difference(){
    union(){

      // Mount points part cooling fan
      difference(){
        translate([0, 0, -5])
        hull(){
          translate([0, mnt_top_Y, (h_h-5)])
          roundedRect([mnt_top_X*2+10, 10, 5], 2);
          translate([0, mnt_top_Y, h_h-20])
          roundedRect([h_wb, 10, 0.1], 2);
        }
//        translate([0, 0, h_h])
//        roundedRect([h_wb+20, 25, 20], 2);
      }
      
      // Hopper body
      roundedRect([h_wb, h_lb, h_h], 5, [0,0,1,1]);

      if(brim){      
				// Brim
				brim_d = 10;
				brim_h = 0.2;
				for(i=[0:1:1])mirror([i, 0, 0])
				for(j=[0:1:1])mirror([0, j, 0])
				translate([h_wb/2, h_lb/2, brim_h/2])
				cylinder(d=brim_d, h=brim_h, center=true);
				
				for(i=[0:1:1])mirror([i, 0, 0])
				translate([lever_w/2-h_wall, lever_l+h_lb/2, brim_h/2])
				cylinder(d=brim_d, h=brim_h, center=true);
			}

/*      
      // Front door mount points
      hull(){
        translate([0, -h_lb/2, h_h/2])
        rotate([-90, 0, 0])
        roundedRect([hfd_screw_dis + 10, 10, 5], 5);
        translate([0, -h_lb/2, 5])
        rotate([-90, 0, 0])
        roundedRect([h_wb, 10, 5], 5);
      }
*/
      
//      // Tray
//      a = tray_w+2*h_wall+tray_tol;
//      translate([0, -tray_l/2, h_h/2])
//      cubec([a, tray_l, h_h]);


      // Lever for rear mount
//      translate([0, (h_lb+lever_l)/2, 0])
//      roundedRect([lever_w, lever_l, h_wall], 5, [0,0,0,0]);
//      translate([0, (h_lb+lever_l)/2, h_h2-h_wall])
//      roundedRect([lever_w, lever_l, h_wall], 5, [0,0,0,0]);
      translate([0, (h_lb+h_wall)/2, h_h2/2])
      cubec([14, h_wall, h_h2]);
      for(i=[0:1:1])mirror([i,0,0])
      translate([lever_w/2-h_wall, (lever_l+h_lb)/2, h_h2/2])
      cubec([h_wall*2, lever_l, h_h2]);
    }

    // Screw holes magnets front door
    translate([0, -h_lb/2, h_h/2])
    rotate([90, 0, 0])
    for(i=[0:1:1])mirror([i,0,0]){
//      translate([mag_X1, mag_Y1,0]){
//        cylinder(d=2.9, h=38, center=true);
//        cylinder(d=6, h=8, center=true);
//      }
      translate([mag_X2, mag_Y2, 0]){
        cylinder(d=M3_hole, h=38, center=true);
        translate([0, 0, -5])
        hull(){
          cylinder(d=M3_nut_e+0.7, h=3.5, center=true, $fn=6);
          translate([10, 0, 0])
          cylinder(d=M3_nut_e+0.7, h=3.5, center=true, $fn=6);
        }
      }


      translate([mag_X3, mag_Y3,0]){
        cylinder(d=M3_hole, h=38, center=true);
        translate([0, 0, -5])
        hull(){
          cylinder(d=M3_nut_e+0.7, h=3.5, center=true, $fn=6);
          translate([10, 0, 0])
          cylinder(d=M3_nut_e+0.7, h=3.5, center=true, $fn=6);
        }
      }

    }

    // Front opening
    translate([0, h_shift_Y, 0])
    translate([0, -tray_l, h_h/2+tray_shift_Z])
    cubec([tray_w, tray_l*2, h_h]);

/*
    // Front door mount points
    for(i=[0:1:1])mirror([i,0,0])
    translate([hfd_screw_dis/2, -h_lb/2, h_h/2])
    rotate([-90, 0, 0]){
      cylinder(d=M3_hole, h=12, center=true);
      translate([0, 0, 6])
      cylinder(d=M3_nut_e, h=8, center=true, $fn=6);
    }
*/    

    // Mount points part cooling fan
    for(j=[0:1:1])mirror([j,0,0])
//    for(i=[0:1:1])mirror([0,i,0])
    translate([mnt_top_X, mnt_top_Y, h_h-10-5]){
      cylinder(d=M3_hole, h=h_h*2, center=true);
      hull(){
        cylinder(d=M3_hole, h=14, center=true);
        cylinder(d=M3_nut_e, h=10, center=true, $fn=6);
      }
    }
    
    // Magnet cuts part cooling fan
    for(i=[0:1:1])mirror([i,0,0])
    translate([h_wb/2, 5-h_lb/2, h_h/2+2])
    rotate([0, 90, 0])
    cylinder(d=6.5, h=10, center=true);

    // Center cut
    translate([0, h_shift_Y, 0]){
      hull(){
        translate([0, 0, h_h/2+5])
        cylinder(d=h_inner_cyl , h=h_h, center=true);
        translate([0, 0, h_wall_b])
        cylinder(d=auger_cut, h=0.1, center=true);
      }
      translate([0, 0, h_h])
      cylinder(d=21, h=4, center=true);

      // auger cut
      cylinder(d=auger_cut, h=h_h+0.1, center=true);
    }
      
    // Mount holes motor
    translate([0, h_shift_Y, 0])
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_mnt_X, motor_mnt_Y, h_h/2]){
        cylinder(d=M3_hole, h=h_h+0.1, center=true);
        translate([0, 0, h_h/2])
        rotate([0, 0, 30])
        cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
      }
    }
  
    // Mount holes force sensor Nextruder
    translate([0, 0, 6+2+M3_hole/2+fs_screw_dis_h/2])
    for(i=[0:1:1])mirror([0,0,i])
    translate([0, h_lb/2+25, fs_screw_dis_h/2])
    rotate([0, 90, 0]){
      cylinder(d=M3_hole, h=lever_w+0.1, center=true);
      rotate([0, 0, 30])
      translate([0, 0, 8])
      cylinder(d=M3_nut_e, h=lever_w, center=true, $fn=6);
      translate([0, 0, (3-(lever_w+0.1))/2])
      cylinder(d2=M3_hole, d1=6, h=3, center=true);
    }
    
    // Cable hole
    translate([5, h_lb/2+7.6, 22])
    rotate([90, 0, 90])
    hull(){
      roundedRect([15,7,10], 2);
      translate([0, 0, -3])
      roundedRect([11,7,10], 2);
    }
    
		// Motor plate screw head cuts
		translate([0, h_shift_Y, h_h])
		for(i=[0:1:3])rotate([0, 0, i*90])
		translate([35/2, 0, 0])
		scale([1,1,0.7])
		sphere(d=10);
		
//    translate([lever_w/2, h_lb/2-0.7, h_h+2])
//    rotate([0, 90, 0])
//    cylinder(d=4, h=lever_w, center=true);
    
    
/*
    // Mount holes bottom mount
    translate([0, hbm_Y1, 0]){
      cylinder(d=M3_hole, h=40, center=true);
    }
    translate([0, hbm_Y2, 0]){
      cylinder(d=M3_hole, h=40, center=true);
    }
*/
  }
  
}

module hopper_spacer(spacer_h = 1, notches = false, brim = false){
  auger_cut = 12;
  h_shift_Y = -6;
  
  // Tray dimensions
  tray_tol = 1;
  tray_s_Y1 = -h_wb/2+2;
  tray_s_Y2 = tray_s_Y1;
  tray_s_Z1 = h_h/2-7.5;
  tray_s_Z2 = h_h-7.5;
  tray_shift_Z = 5;
  tray_w = h_inner_cyl;
  tray_l = h_lb/2-3;
  
  // Force sensor mount  
  lever_h = 2;
  lever_l = 32;
  lever_w = 18.5;
  
//  translate([0, 40, 29])cubec([10,10,10]);
  
  difference(){
    union(){

      
      // Hopper body
      roundedRect([h_wb, h_lb, h_h], 5, [0,0,1,1]);
			for(i=[0:1:1])mirror([i, 0, 0])
			translate([(10-h_wb)/2, (-10-h_lb)/2, h_h/2])
		  cubec([10, 10, h_h])

      if(brim){
				// Brim
				brim_d = 10;
				brim_h = 0.2;
				for(i=[0:1:1])mirror([i, 0, 0])
				for(j=[0:1:1])mirror([0, j, 0])
				translate([h_wb/2, h_lb/2, brim_h/2])
				cylinder(d=brim_d, h=brim_h, center=true);
				
				for(i=[0:1:1])mirror([i, 0, 0])
				translate([lever_w/2-h_wall, lever_l+h_lb/2, brim_h/2])
				cylinder(d=brim_d, h=brim_h, center=true);
			}

    }


    translate([0, 0, -0.05])
    roundedRect([100, 100, h_h-spacer_h], 1)

    // Front opening
    translate([0, h_shift_Y, 0])
    translate([0, -tray_l, h_h/2+tray_shift_Z])
    cubec([tray_w, tray_l*2, h_h]);



    // Center cut
    translate([0, h_shift_Y, 0]){
      hull(){
        translate([0, 0, h_h/2+5])
        cylinder(d=h_inner_cyl , h=h_h, center=true);
        translate([0, 0, h_wall_b])
        cylinder(d=auger_cut, h=0.1, center=true);
      }
      translate([0, 0, h_h])
      cylinder(d=21, h=4, center=true);

      // auger cut
      cylinder(d=auger_cut, h=h_h+0.1, center=true);
    }
      
    // Mount holes motor
    translate([0, h_shift_Y, 0])
    for(i=[0:1:1])mirror([i,0,0])
    for(j=[0:1:1])mirror([0,j,0]){
      translate([motor_mnt_X, motor_mnt_Y, h_h/2]){
        cylinder(d=M3_hole, h=h_h+0.1, center=true);
//        translate([0, 0, h_h/2])
//        rotate([0, 0, 30])
//        cylinder(d=M3_nut_e, h=6, center=true, $fn=6);
      }
    }
  
    
		// Motor plate screw head cuts
		if(notches)
		translate([0, h_shift_Y, h_h])
		for(i=[0:1:3])rotate([0, 0, i*90])
		translate([35/2, 0, 0])
		scale([1,1,0.7])
		sphere(d=10);
		
  }
  
}


// ###############################################
// ###############################################
// ###############################################

module roundedCube(size, radius, f=50){
  x = size[0];
  y = size[1];
  z = size[2];

  hull(){
    translate([x/2-radius, y/2-radius, z/2-radius])
    sphere(r=radius, $fn=f);
    translate([-(x/2-radius), y/2-radius, z/2-radius])
    sphere(r=radius, $fn=f);
    translate([-(x/2-radius), -(y/2-radius), z/2-radius])
    sphere(r=radius, $fn=f);
    translate([x/2-radius, -(y/2-radius), z/2-radius])
    sphere(r=radius, $fn=f);

    translate([x/2-radius, y/2-radius, -(z/2-radius)])
    sphere(r=radius, $fn=f);
    translate([-(x/2-radius), y/2-radius, -(z/2-radius)])
    sphere(r=radius, $fn=f);
    translate([-(x/2-radius), -(y/2-radius), -(z/2-radius)])
    sphere(r=radius, $fn=f);
    translate([(x/2-radius), -(y/2-radius), -(z/2-radius)])
    sphere(r=radius, $fn=f);
  }
}

module cubec(size=[1,1,1]){
  cube(size, center=true);
}


module roundedRect(size, radius, edges=[1, 1, 1, 1], vscale=[1,1], shift=0){
  x = size[0];
  y = size[1];
  z = size[2];

  translate([0, -shift*2, 0]){
    linear_extrude(height=z, scale=[vscale[0], vscale[1]]){
      translate([0, shift*2, 0]){
        hull(){
            // place 4 circles in the corners, with the given radius
            if(edges[0]){
              translate([(-x/2)+(radius), (-y/2)+(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(-x/2)+(radius/2), (-y/2)+(radius/2), 0])
              square(size=[radius, radius], center=true);
            }
            if(edges[1]){
              translate([(x/2)-(radius), (-y/2)+(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(x/2)-(radius/2), (-y/2)+(radius/2), 0])
              square(size=[radius, radius], center=true);
            }

            if(edges[2]){
              translate([(-x/2)+(radius), (y/2)-(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(-x/2)+(radius/2), (y/2)-(radius/2), 0])
              square(size=[radius, radius], center=true);
            }

            if(edges[3]){
              translate([(x/2)-(radius), (y/2)-(radius), 0])
              circle(r=radius);
            }
            else{
              translate([(x/2)-(radius/2), (y/2)-(radius/2), 0])
              square(size=[radius, radius], center=true);
            }
          }
       }
    }
  }
}